#ifndef lint
static char *RCSid = "$Header: /empire/empire/EMP/player/commands/rang.c 1.0 90/12/19 02:33:10 bailey Exp $";
#endif

/*
 * rang.c
 *
 * Edit effective range of a plane.
 *
 * Jeff Bailey
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "plane.h"
#include "nsc.h"
#include "file.h"
#include "nat.h"
#include "deity.h"

range()
{
	extern char *argp[];
	struct nstr_item np;
	struct plnstr plane;
	int	i;
	char	*p;

	if (!snxtitem(&np, EF_PLANE, argp[1]))
		return RET_SYN;
	while (nxtitem(&np, (char *)&plane)) {
		if (!owner || plane.pln_own == 0)
			continue;
		p = getstarg(argp[2],"New range? ");
		if ((i = atoi(p)) <= 0)
			continue;
		plane.pln_range = (plane.pln_range_max < i) ?
			plane.pln_range_max : i;
		pr(fmt("Plane %d range changed to %d\n",plane.pln_uid,
			plane.pln_range));
		putplane(plane.pln_uid,&plane);
	}

	return RET_OK;
}
