#include <stdio.h>
#include <fcntl.h>
#include "options.h"
#include "misc.h"
#include "var.h"
#include "nat.h"

main()
{
    FILE    *fp, *fopen();
    int     natf, x, n;
    struct natstr *np;
    struct natstr all[MAXNOC+1];
    char    *sprintf(), buf[80];

    if ((fp=fopen("nation.ascii", "r")) == (FILE *)0){
        fprintf(stderr,"Cannot open nation.ascii!\n");
        exit(-1);
    }

    np = all;
    for(x=0;x<MAXNOC;x++,np++)
        read_nation(np, fp, x);
    fclose(fp);

    unlink(sprintf(buf,"%s/nation",DATADIR));
    natf = open(sprintf(buf,"%s/nation",DATADIR), O_WRONLY|O_CREAT, 0);
    n=write(natf, all, MAXNOC*sizeof(struct natstr));
    close(natf);

    printf("Writing %s/nation\n",DATADIR);
    printf("wrote %d bytes out of %d!\n",n,MAXNOC*sizeof(struct natstr));
}

read_nation(np, fp, cnum)
struct natstr *np;
FILE *fp;
int  cnum;
{
    int x, y, ind, relate, reject;
    float f;
    long l;
    char c;

    for(y=0;y<20;y++){
        fscanf(fp,"%d",&x);
        np->nat_cnam[y] = x;
        }
    printf("Reading: '%s'\n",np->nat_cnam);

    for(y=0;y<20;y++){
        fscanf(fp,"%d",&x);
        np->nat_pnam[y] = x;
        }

    fscanf(fp,"%d",&x);
    np->nat_xcap = (coord)x;
    fscanf(fp,"%d",&x);
    np->nat_ycap = (coord)x;
    fscanf(fp,"%d",&x);
    np->nat_xorg = (coord)x;
    fscanf(fp,"%d",&x);
    np->nat_yorg = (coord)x;
    fscanf(fp,"%d",&x);
    np->nat_stat = (char)x;
    fscanf(fp,"%d",&x);
    np->nat_dayno = (char)x;
    fscanf(fp,"%d",&x);
    np->nat_login = (char)x;
#ifdef	DEMANDUPDATE
    fscanf(fp,"%d",&x);
    np->nat_update = (char)x;
#endif	DEMANDUPDATE
    fscanf(fp,"%d",&x);
    np->nat_tgms = x;
    fscanf(fp,"%d",&x);
    np->nat_minused = x;
    fscanf(fp,"%d",&x);
    np->nat_btu = x;
    fscanf(fp,"%D",&l);
    np->nat_reserve = l;
    fscanf(fp,"%D",&l);
    np->nat_money = l;
    fscanf(fp,"%D",&l);
    np->nat_date = l;
    fscanf(fp,"%D",&l);
    np->nat_newstim = l;
    for(y=0;y<4;y++){
        fscanf(fp,"%f ",&f);
	np->nat_level[y] = f;
        }

    for(y=0;y<MAXNOR;y++){
        fscanf(fp,"%d ",&x);
	np->nat_b[y].b_xl = (short)x;
        fscanf(fp,"%d ",&x);
	np->nat_b[y].b_xh = (short)x;
        fscanf(fp,"%d ",&x);
	np->nat_b[y].b_yl = (short)x;
        fscanf(fp,"%d ",&x);
	np->nat_b[y].b_yh = (short)x;
        }

#ifdef SLOW_WAR
    for(y=0;y<MAXNOC;y++){
        fscanf(fp,"%d ",&x);
        np->nat_relate[y] = (short)x;
        }
#else
    for(y=0;y<MAXNOC;y++){
        fscanf(fp,"%d ",&x);
        np->nat_relate[y] = (short)x;
        }
#endif /* SLOW_WAR */
#ifdef	REJECTS				/* 3/17/90 bailey@mcs.kent.edu */
    for(y=0;y<MAXNOC;y++){
        fscanf(fp,"%d ",&x);
        np->nat_rejects[y] = (short)x;
        }
#endif	REJECTS
}
