/* $Id: prog.c,v 1.6 1993/02/06 20:55:19 nils Exp $ */
/* file containing programming commands. */

#include "config.h"
#include "externs.h"

void do_switch(player,exp,argv,cause)
     dbref player;
     char *exp;
     char *argv[];
     dbref cause;
{
  int any=0,a,c;
  char buff[1024];            
  char *ptrsrv[10];
  strcpy(buff,exp);
  if (!argv[1])
    return;
  for(c=0;c<10;c++)
    ptrsrv[c]=wptr[c];
  /* now try a wild card match of buff with stuff in coms */
  for(a=1;(a<(MAX_ARG-1)) && argv[a] && argv[a+1];a+=2)
    if (wild_match(argv[a],buff))
      {
	any=1;          
	for(c=0;c<10;c++)
	  wptr[c]=ptrsrv[c];
	parse_que(player,argv[a+1],cause);
      }                              
  for(c=0;c<10;c++)
    wptr[c]=ptrsrv[c];
  if ((a<MAX_ARG) && !any && argv[a])                              
    parse_que(player,argv[a],cause);
}

void do_foreach(player, list, command, cause)
     dbref player;
     char *list, *command;
     dbref cause;
{
  char *k;
  char *ptrsrv[10];
  int c;

  for(c=0;c<10;c++)
    ptrsrv[c] = wptr[c];
  for(c=0;c<10;c++)
    wptr[c] = "";
  while ((k=parse_up(&list, ' '))) {
    wptr[0] = k;
    parse_que(player, command, cause);
  }
  for(c=0;c<10;c++)
    wptr[c] = ptrsrv[c];
}

void do_trigger(player,object,argv)
     dbref player;
     char *object;
     char *argv[];
{
  dbref thing;
  dbref thing_zone;
  ATTR *attrib;
  int a;

  if (!parse_attrib(player,object,&thing,&attrib,POW_SEEATR)) {
    notify(player,"No match.");
    return;
  }
  if (!controls(player,thing,POW_MODIFY)) {
    notify(player,"Permission denied.");
    return;
  }
  if ((thing_zone = get_zone(thing)) != get_zone(player) &&
      !power(player, POW_REMOTE) &&
      IS(thing_zone,TYPE_THING,THING_ZONED) &&
      db[thing_zone].flags & OPAQUE) {
	notify(player,"That object is in a different restricted zone.");
	return;
      }
  if ( thing == GOD ) {
    notify(player,"You can't trigger god!");
    return;
  }
  for(a=0;a<10;a++)
    wptr[a]=argv[a+1];
  did_it(player,thing,NULL,0,NULL,0,attrib);
  if(!(db[player].flags&QUIET))
    notify(player,
	   tprintf("%s - Triggered.",db[thing].name));
}

void do_decompile (player, arg1)
     dbref player;
     char *arg1;
{
  dbref obj;
  ALIST *a;
  ATRDEF *k;
  char buf[1024];
  char *s;

  obj = match_thing (player, arg1);
  if (obj == NOTHING)
    return;
  if ((!controls(player,obj,POW_SEEATR) || !controls(player,obj,POW_EXAMINE)) && !(db[obj].flags&SEE_OK)) {
    notify(player,"Permission denied.");
    return;
  }
  s = flag_description(obj);
  if ((s=strchr(s,':')) && (s=strchr(++s,':'))) {
    char *g;
    s+=2;
    while ((g=parse_up(&s,' ')))
      notify(player,tprintf("@set %s=%s",db[obj].name,g));
  }

  if (db[obj].atrdefs) {
    for (k=db[obj].atrdefs; k; k=k->next) {
      sprintf(buf,"@defattr %s/%s%s",
	       db[obj].name,
	       k->a.name,
	      (k->a.flags)?"=":"");
      if (k->a.flags & AF_WIZARD)
	strcat(buf, " wizard");
      if (k->a.flags & AF_UNIMP)
	strcat(buf, " unsaved");
      if (k->a.flags & AF_OSEE)
	strcat(buf, " osee");
      if (k->a.flags & AF_INHERIT)
	strcat(buf, " inherit");
      if (k->a.flags & AF_DARK)
	strcat(buf, " dark");
      if (k->a.flags & AF_DATE)
	strcat(buf, " date");
      if (k->a.flags & AF_LOCK)
	strcat(buf, " lock");
      if (k->a.flags & AF_FUNC)
	strcat(buf, " function");
      notify(player, buf);
    }
  }

  for (a=db[obj].list; a; a=AL_NEXT(a))
    if (AL_TYPE(a))
      if (!(AL_TYPE(a)->flags&AF_UNIMP))
	if (can_see_atr (player, obj, AL_TYPE(a))) {
	  if ( AL_TYPE(a)->obj == NOTHING )
	    sprintf(buf, "%s", unparse_attr(AL_TYPE(a),0));
	  else {
	    sprintf(buf, "#%d", obj);
	    sprintf(buf, "%s%s", db[obj].name, unparse_attr(AL_TYPE(a),0)+strlen(buf));
	  }
	  notify(player,tprintf("@nset %s=%s:%s",db[obj].name,
				buf,
				uncompress(AL_STR(a))));
	}
}
