/* --------------------------------- log.c ---------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* log file stuff.
*/

#include "fly.h"


#define NOTHINGTOLOG	0xffffffffUL

static FILE *flog = 0;

extern int FAR
log_init (void)
{
	char	*lname;

	STATS_LOGTIME = NOTHINGTOLOG;

	if (F(lname = st.lname))
		lname = LOGFILE;

	if (!(flog = fopen (lname, ATMODE))) {
#ifndef NOSTDERR
		fprintf (stderr, "open failed for log file '%s'\n", lname);
#endif
		return (1);
	}
	return (0);
}

extern void FAR
log_term (void)
{
	if (flog) {
		fclose (flog);
		flog = 0;
	}
}

extern int FAR
log_flush (int now)
{
	if (NOTHINGTOLOG == STATS_LOGTIME)
		return (0);
	if (!now && st.present < (Ulong)STATS_LOGTIME)
		return (0);
	STATS_LOGTIME = NOTHINGTOLOG;
	if (flog) {
		log_term ();
		if (log_init())
			return (-1);
	}
	return (0);
}

extern int FAR
LogPrintf (const char *fmt, ...)
{
	va_list		ap;
	int		i;

	if (!flog) {
#ifndef NOSTDERR
		va_start (ap, fmt);
		i = vfprintf (stderr, fmt, ap);
		fflush (stderr);
		va_end (ap);
		return (i);
#endif
		return (-1);
	}

	va_start (ap, fmt);
	i = vfprintf (flog, fmt, ap);
	va_end (ap);

	STATS_LOGTIME = st.present + (st.misc[9] > 0 ? st.misc[9] : 0);
	log_flush (0);

	return (i);
}

extern void FAR
LogDumpHex (char *title, Uchar *h, int hlen)
{
	int	i;

	LogPrintf ("%s:", title);
	for (i = 0; i < hlen; ++i) {
		if (!(i%32))
			LogPrintf ("\n  ");
		else if (!(i%16))
			LogPrintf ("   ");
		else if (!(i%4))
			LogPrintf (" ");
		LogPrintf ("%02x", h[i]);
	}
	LogPrintf ("\n");
}
