// Copyright 1994 Brad Pitzel
//
// Feel free to use/distribute/modify as long as credit/copyrights for myself 
// and contributors are included.

// File   : Sprite.c[1.0]
// Name   : gamelib1.0
// Status : proposed
// Changed: Sun Jun 12 22:18:12 1994

#include "Sprite.h"


// *Friend Function*
// Determine if 2 Sprites have collided. Assumes the images are round.
// Returns 1 if the 2 objects collided, 0 otherwise.
int collide(const Sprite& b1, const Sprite& b2)
{
	int d = b1.Vsize + b2.Vsize;
	int dx= FP2INT( abs(b1.VFx - b2.VFx) );
	int dy= FP2INT( abs(b1.VFy - b2.VFy) );

	if ((dx <= d) && (dy <= d))
		if ( (dx*dx+dy*dy) < d*d)
			return 1;
	return 0;
}

