// Copyright 1994 Brad Pitzel
//
// Feel free to use/distribute/modify as long as credit for myself 
// and contributors are included.
//
// Parts of Keyboard.c and Keyboard.h contain code taken from the rawkey
// library written by Russel Marks.

#ifndef __Keyboard__
#define __Keyboard__

#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <linux/keyboard.h>
#include <linux/vt.h>	
#include <vgakeyboard.h>
#include <iostream.h>

#undef EGA		// conflict between linux/kd.h and vga.h
#include <linux/kd.h>

// Scan codes of a few more useful keys, not defined in the svgalib keyboard
// handling (yet)
#define LEFT_SHIFT	0x2A
#define RIGHT_SHIFT	0x36
#define LEFT_CTRL	0x1D
#define LEFT_ALT	0x38


// convert ascii char into corresponding scancode
#define SCANCODE(x) Keyboard::scancode_trans(x)

class Keyboard {
    public:
    
	static int  init();
	static void restore() 
			{ 
			keyboard_close(); 
			}

	static void update();
	static int  keypressed(int key) { return keyboard_keypressed(key); }
	static int  keyhit(int key);
	static void setdelay(int key, int ticks);

	static int make_keyb_map();
	static void make_ascii_map();
	static int keymap_trans(int);
	static int scancode_trans(int);

	static void clearhit();
	    
    private:

	static unsigned char hitState[NR_KEYS];
	static int           delay[NR_KEYS];
	static int           count[NR_KEYS];

	static int keymap[NR_KEYS];   // scancode -> ASCII translation
	static int asciimap[256];     // ASCII -> scancode translation

    };

//////////////////////////////////////////////////////////////////////////////
// check for key hit, with repeat determined by delay[key]
inline int Keyboard::keyhit(int key) return r;
	{
	if (delay[key])
		{
		r=hitState[key];
		hitState[key]=0;
		}
	else	r=keyboard_keypressed(key);
	}

#endif
