/* 
Copyright notice:

This is mine.  I'm only letting you use it.  Period.  Feel free to rip off
any of the code you see fit, but have the courtesy to give me credit.
Otherwise great hairy beasties will rip your eyes out and eat your flesh
when you least expect it.

Jonny Goldman <jgoldman@parc.xerox.com>

Tue Jul 17 1990
*/

/* vaders.c - handle movement, etc. of the vaders. */

#include "vaders.h"

#define NUMTYPES	3	/* How many types of vaders there are. */
#define NUMROWS		5	/* number of rows of vaders */
#define NUMVADERS	11	/* Maximum of vaders of each type. */
#define BASEY 10
#define VADERWIDTH	(14*scale)
#define VADERHEIGHT	(12*scale)
#define VADERYINC	(8*scale)

static XImage *Vader_Image[NUMTYPES][2];	/* XImages for the vaders. */

extern int basex;		/* Base location */

static int tick = 0;
static int vaderwaitinit;

typedef struct _VaderRec {
  int x, y;			/* Location. */
  int vx, vy;			/* Velocity. */
  int width, height;		/* size of this Vader. */
  GC gc;			/* graphics context */
  XImage *shape_image[2];
  int value;
  Boolean alive;
  Boolean exploded;
} VaderRec, *Vader;

VaderRec vaders[NUMROWS][NUMVADERS];

int numvaders = 0;		/* Number of vaders existing. */


typedef struct _BaseRec {
  int x;			/* Location. */
  int v;			/* velocity */
  int width, height;		/* box of this base. */
  XImage *shape_image;		/* an XImage for the spaceship */
} BaseRec, *Base;

extern Base base;

XImage *Explode_image;

/* indicates pad around vader bitmap for better collision detection */
#define VADERPAD 	scale

#define PointInVader(vader, x, y)	\
  (x >= (vader)->x+VADERPAD && y >= (vader)->y &&		\
   x <= (vader)->x + (vader)->width-VADERPAD  && y <= (vader)->y + (vader)->height)

static void PaintVader(vader, gc)
     Vader vader;
     GC gc;
{
  int rx, ry, w, h;
  
  w = vader->width;
  h = vader->height;

  rx = vader->x;
  ry = vader->y;
  
  XPutImage(dpy, gamewindow, gc, vader->shape_image[tick],
	    0, 0, rx, ry, w, h);
}

static void PaintExplodedVader(vader, gc)
     Vader vader;
     GC gc;
{
  int rx, ry, w, h;
  
  w = Explode_image->width;
  h = Explode_image->height;

  rx = vader->x;
  ry = vader->y;
  
  XPutImage(dpy, gamewindow, gc, Explode_image,
	    0, 0, rx, ry, w, h);
}

static void DestroyVader(vader)
Vader vader;
{
  int oldx = vader->x;
  int oldy = vader->y;
  PaintVader(vader, backgc);
  score += vader->value;
  PaintScore();
  numvaders--;
  switch (numvaders) {
  case 32:
  case 16:
  case 8:
  case 4:
  case 2:
  case 1:
    vaderwait /= 2; break;
  }
  vader->alive = FALSE;
  vader->exploded = TRUE;
  PaintExplodedVader(vader, vader->gc);
}



Boolean ShotHitsVader(x, y)
     int x, y;
{
  register Vader vader;
  int i, j;

  for(j = 0; j < NUMROWS; j++)
    for (i=0 ; i<NUMVADERS ; i++) {
      vader = &vaders[j][i];
      if(vader->alive && PointInVader(vader, x, y)) {
	DestroyVader(vader);
	return TRUE;
    }
  }
  return FALSE;
}



void PaintAllVaders()
{
  int i, j;
  Vader vader;

  for(j = 0; j < NUMROWS; j++)
    for (i=0 ; i< NUMVADERS ; i++) {
      vader = &vaders[j][i];
      if(vader->alive) PaintVader(vader, vader->gc);
    }
}

/* add some random shot */

void SFire()
{
  register Vader vader;
  int i, j, c;

  for(j = 0, c = random()%NUMVADERS; j < NUMVADERS; j++) {
    for (i= NUMROWS-1; i>=0; i--) {
      vader = &vaders[i][(c+j)%NUMVADERS];
      if(vader->alive) {
	AddVshot(vader->x+vader->width/2, vader->y+vader->height);
	return;
      }
    }
  }
}

static int createvaderp = FALSE;

void MoveVaders(closure, id)
     Opaque closure;
     XtIntervalId id;
{
  register Vader vader;
  register int i, j;
  Boolean reversep;

  reversep = FALSE;

  if (closure != (Opaque) MoveVaders) return;
  if (createvaderp) {
    createvaderp = FALSE;
    CreateVaders(level);
  }
  if (numvaders == 0 && numvshots == 0) {
    vadertimerid = XtAddTimeOut(2000, MoveVaders, (Opaque) MoveVaders);
    level++;
    createvaderp = TRUE;
    InitBuildings();
    DrawBuildings();
  } else {
    vadertimerid = XtAddTimeOut(vaderwait, MoveVaders, (Opaque) MoveVaders);
    if((random()%1000)>900) SFire();
    for(j = 0; j < NUMROWS; j++)
      for (i=0 ; i< NUMVADERS ; i++) {
	vader = &vaders[j][i];
	if (vader->exploded) {
	  PaintExplodedVader(vader, backgc);
	  vader->exploded = FALSE;
	}
	else if (vader->alive) {
	  if (vader->vx > 0)
	    ShotHitsBuilding(vader->x+vader->width, vader->y+vader->height);
	  else
	    ShotHitsBuilding(vader->x, vader->y+vader->height);
	  vader->x += vader->vx;
	  if ((vader->x < (VADERWIDTH-vader->width)/2 && vader->vx < 0) || 
	      (vader->x > gamewidth-VADERWIDTH && vader->vx > 0))
	    reversep = TRUE;
	  tick = tick ? 0 : 1;
	  PaintVader(vader, vader->gc);
	  tick = tick ? 0 : 1;
	}
      }
    tick = tick ? 0 : 1;
    if (reversep) {
      for(j = 0; j < NUMROWS; j++)
	for (i=0 ; i< NUMVADERS ; i++) {
	  vader = &vaders[j][i];
	  if (vader->alive) {
	    PaintVader(vader, backgc);
	    vader->vx = -vader->vx;
	    vader->y = vader->y + VADERYINC;
	    PaintVader(vader, vader->gc);
	    if(vader->y >= gameheight-base->height+vader->height) {
	      ResetGame();
	      return;
	    }
	  }
	}
    }
  }
}


int ReadVaderImages()
{
  unsigned int width, height;
  int x_hot, y_hot;
  char *data, filename[255];
  int i, j, status;

  for (i = 0; i < NUMTYPES; i++)
    for (j = 0; j < 2; j++) {
      sprintf(filename, "%svader%d%s%d.bit", bitdir, (i+1), (j ? "b" : "a"), scale); 
      status = XmuReadBitmapDataFromFile (filename,
					  &width, &height, &data,
					  &x_hot, &y_hot);

      if (status != BitmapSuccess) return status;

      Vader_Image[i][j] = XCreateImage(dpy,
				       DefaultVisual(dpy, DefaultScreen(dpy)),
				       1,
				       XYBitmap,
				       0,
				       data,
				       width, height,
				       8, 0);
      Vader_Image[i][j]->bitmap_bit_order = LSBFirst;
      Vader_Image[i][j]->byte_order = LSBFirst;
    }

  sprintf(filename, "%svexplod%d.bit", bitdir, scale); 
  status = XmuReadBitmapDataFromFile (filename,
				      &width, &height, &data,
				      &x_hot, &y_hot);

  if (status != BitmapSuccess) return status;

  Explode_image = XCreateImage(dpy,
			       DefaultVisual(dpy, DefaultScreen(dpy)),
			       1,
			       XYBitmap,
			       0,
			       data,
			       width, height,
			       8, 0);
  Explode_image->bitmap_bit_order = LSBFirst;
  Explode_image->byte_order = LSBFirst;

  return BitmapSuccess;
}


void CreateVaders(level)
int level;
{
  int offset, i, j;
  Vader vader;

  offset = MIN(level, 8);
  vaderwait = vaderwaitinit;
  numvaders = NUMROWS*NUMVADERS;
  for (j = 0; j < NUMROWS; j++)
    for (i = 0; i < NUMVADERS; i++) {
      vader = &vaders[j][i];
      vader->x = 3 + VADERWIDTH*i+(VADERWIDTH-vader->width)/2;
      vader->y = VADERHEIGHT*(offset+j);
      vader->vx = scale;
      vader->alive = TRUE;
      vader->exploded = FALSE;
    }
}

void InitVaders()
{
  int i, j, k, width, height;
  Vader vader;

  level = 1;
  if (ReadVaderImages() != BitmapSuccess) {
    fprintf(stderr, "Error reading Invader images\n");
    exit(10);
  }

  for (j = 0; j < NUMROWS; j++) {
    switch (j) {
    case 0:
      k = 0; break;
    case 1:
    case 2:
      k = 1; break;
    case 3:
    case 4:
      k = 2; break;
    }
    width = Vader_Image[k][0]->width;
    height = Vader_Image[k][0]->height;
    for (i = 0; i < NUMVADERS; i++) {
      vader = &vaders[j][i];
      vader->shape_image[0] = Vader_Image[k][0];
      vader->shape_image[1] = Vader_Image[k][1];
      vader->gc = vadergc[k];
      vader->width = width;
      vader->height = height;
      vader->value = 10*(3-k);
    }
  }
  vaderwaitinit = vaderwait;
  CreateVaders(level);
  vadertimerid = NULL;
}
