/*
**	MIDIMODE -- Make modes explicit in MIDI commands
**	psl 10/85
*/
#include	<stdio.h>
#include	<midi.h>

#define	MAXCHAN	16

main(argc, argv)
char	*argv[];
{
	register int i, dt, curmode, chan, pflg;

	while (--argc > 0) {
	    if (argv[argc][0] == '-') {
		switch (argv[argc][1]) {
		default:
		    goto syntax;
		}
	    } else {
syntax:
		fprintf(stderr, "Usage: %s <old >new", argv[0]);
		exit(2);
	    }
	}
	chan = -1;
	while ((i = getc(stdin)) != EOF) {
	    putc(i, stdout);
	    if (i == RT_TCIP || i == RT_TCIS)
		continue;
	    if ((i = getc(stdin)) == EOF) {
		fprintf(stderr, "unexpected EOF\n");
		exit(1);
	    }
	    if (i & M_CMD) {
		if ((i & M_CMD_MASK) == 0xF0) {	/* the F# weirdos */
		    putc(i, stdout);
		    if (i < 0xF8) {		/* sys excl or sys common */
			if (i == SX_CMD) {	/* sys excl */
			    do {
				i = getc(stdin);
				putc(i, stdout);
			    } while (i != SX_EOB);
			} else if (i == SC_MSEL) {	/* song position */
			    putc(getc(stdin), stdout);
			    putc(getc(stdin), stdout);
			} else if (i == SC_SSEL)	/* song select */
			    putc(getc(stdin), stdout);
		    }
		    continue;
		}
		chan = i % MAXCHAN;
		curmode = i;
		if ((i = getc(stdin)) == EOF) {
		    fprintf(stderr, "unexpected EOF\n");
		    exit(1);
		}
	    }
	    if (chan == -1) {
		fprintf(stderr, "Data precedes mode command\n");
		exit(1);
	    }
	    putc(curmode, stdout);
	    putc(i, stdout);
	    i = (curmode & M_CMD_MASK);
	    if (i == CH_KEY_ON
	     || i == CH_KEY_OFF
	     || i == CH_POLY_KPRS
	     || i == CH_CTL
	     || i == CH_P_BEND) {
		if ((i = getc(stdin)) == EOF) {
		    fprintf(stderr, "unexpected EOF\n");
		    exit(1);
		}
		putc(i, stdout);
	    }
	}
	exit(0);
}
