/*
**	char *key2name((int) key)
**		return ascii name of the specified MIDI key
**	int name2key((char) *name)
**		return MIDI key number for the ascii key name
**	char *key2pc((int) key)
**		return ascii pitch class name of the specified MIDI key
**	int pc2key((char) *name)
**		return MIDI key number for the ascii pitch class name
**	Ascii key name can be 'C#3', 'Db3', '61', '075', or '0x3d';
**	(generated ascii key names will be in the form 'Db3').
**	Ascii pitch class name can be 'C#', 'Db', '61', '075', or '0x3d'.
**	(generated ascii pitch class names will be in the form 'Db').
**	Changed 1/1/89 to make middle C == C3 == 60.
**	psl 9/88
*/

static	char	*Nn[]	= {
	"C", "Db", "D", "Eb", "E", "F", "Gb", "G", "Ab", "A", "Bb", "B", 0,
};

char	*
key2name(key)
{
	register char *bp, *cp, oct;
	static char buf[5];

	for (bp = buf, cp = Nn[key%12]; *bp = *cp++; bp++);
	oct = key / 12 - 2;
	if (oct < 0) {
	    *bp++ = '-';
	    oct = -oct;
	}
	*bp++ = '0' + oct;
	*bp++ = '\0';
	return(buf);
}

name2key(n)
char	*n;
{
	register int pc, o;

	if (('0' <= *n && *n <= '9') || *n == '-' || *n == '+')
	    return(myatoi(n));
	for (pc = 0; Nn[pc] && (Nn[pc][0] != n[0] || Nn[pc][1] == 'b'); pc++);
	if (!Nn[pc])
	    return(0);
	for (o = 1; n[o] == 'b' || n[o] == '#'; o++)
	    pc += n[o] == '#' ? 1 : -1;
	for (; n[o] == '+'; o++);
	o = (n[o] == '-')? ('0' - n[o+1]) : (n[o] - '0');
	return(pc + o * 12 + 24);
}

char	*
key2pc(key)
{
	register char *bp, *cp;
	static char buf[5];

	for (bp = buf, cp = Nn[key%12]; *bp = *cp++; bp++);
	return(buf);
}

pc2key(n)
char	*n;
{
	register int pc, o;

	if (('0' <= *n && *n <= '9') || *n == '-' || *n == '+')
	    return(myatoi(n) % 12);
	for (pc = 0; Nn[pc] && (Nn[pc][0] != n[0] || Nn[pc][1] == 'b'); pc++);
	if (!Nn[pc])
	    return(-1);
	for (o = 1; n[o] == 'b' || n[o] == '#'; o++)
	    pc += n[o] == '#' ? 1 : -1;
	return((pc + 12) % 12);
}
