#import <dpsclient/dpsclient.h>
#import <objc/Object.h>

/*

  Ronin Consulting, Inc.
    Copyright (C) 1992, Nicholas Christopher (nwc@gun.com)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

typedef enum 
{ 
   NO_SPROC, 
   BUILDING_MENU, 
   HOST_QUEUE, 
   POLL_HOST, 
   DELETE_JOB, 
   SNAP_HOSTS,
   GET_BPS
} sProcs;

   
@interface ConController:Object
{
   DPSTimedEntry teNum;
   id hostsPopUp;
   id window;
   id logfile;
   id syslog;
   id consoleLog;
   sProcs procType;
   id progress;
   id subProc;
   id auditProc;
   char *auditFile;
   id defaults;
   id infoController;
}

- init;
- pollHost:sender;
- deleteJob:sender;
- hostsQueue:sender;
- hostsSnap:sender;
- getBPS: sender;
- setConsoleLog:sender;
- keyWindowLogClear: sender;
- logClear;
- logfile: sender;
- syslog: sender;

@end


@interface ConController (ApplicationDelegate)

- appDidInit:sender;
- appWillTerminate:sender;

@end


@interface ConController (SubprocessDelegate)

- subprocess:sender done:(int)exitStatus;
- subprocess:sender output:(char *)buffer;
- subprocess:sender stderrOutput:(char *)buffer;
- subprocess:sender error:(const char *)errorString;

@end


