/*

  Ronin Consulting, Inc.
    Copyright (C) 1992, Nicholas Christopher (nwc@gun.com)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
/*
** Defaults.h,v 1.2 1992/09/15 14:59:07 nwc Exp
**
** This object is designed to simplyfy the use of the NeXT defaults facilities.
**
*/

#import <objc/Object.h>
#import <defaults/defaults.h>

@interface Defaults : Object
{
   const char *appName;
   BOOL registered;
}

/*
** This is a shared object so allocate it with new.
*/
+ new;

/*
** Register a defaults vector. If no vector is registered before a get/set (or any other) call is
** used then an empty vector is used.
*/
- regDefaults: (NXDefaultsVector) defaultsVector; 

/*
** Get/Set a default.
*/
- (const char *) get: (const char *) aDefault;
- set: (const char *) aDefault to: (const char *)aValue;

/*
** Get/Set that Ignore the cached values and use the actual database.
*/
- (const char *) readDB: (const char *) aDefault;
- writeDB: (const char *) aValue as: (const char *)aValue;

/*
** Remove a default from the database.
*/
- remove: (const char *) aDefault;

/*
** Update the cached default from the file.
*/
- update: (const char *) aDefault;

/*
** Update ALL cached values from the database.
*/
- update;

@end


