/*

  Ronin Consulting, Inc.
    Copyright (C) 1992, Nicholas Christopher (nwc@gun.com)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
#import "EnhancedApp.h"
#import <defaults/defaults.h>
#import <sys/param.h>
#import <string.h>
#import <libc.h>

@implementation Application (EnhancedApp)

- (const char *) appDirectory
{
   static char appDirectory[MAXPATHLEN + 1] = { '\0' };
   char *ptr;

   if(!appDirectory[0])
   {
      strcpy(appDirectory, NXArgv[0]);
      if(ptr = rindex(appDirectory, '/'))
	  *ptr = (char)0;

      if(appDirectory)
	  chdir(appDirectory);

      getwd(appDirectory);
   }

   return appDirectory;
}

@end


