#import "ProgressView.h"
#import <appkit/Cell.h>
#import <dpsclient/psops.h>

@implementation ProgressView

- initFrame:(const NXRect *)frameRect
{
    [super initFrame:frameRect];
    total = MAXSIZE;
    stepSize = DEFAULTSTEPSIZE;
    return self;
}

- drawSelf:(const NXRect *)rects :(int)rectCount
{
    PSsetgray(NX_LTGRAY);
    NXRectFill(&bounds); 
    if (ratio > 0) {
        NXRect r = bounds;  
        r.size.width = bounds.size.width * ratio; 
        PSsetgray(NX_DKGRAY);
        NXRectFill(&r); 
    }
    PSsetgray(NX_BLACK);
    NXFrameRect(&bounds);
    return self;
}

- setStepSize:(int)value
{
    stepSize = value;
    return self;
}

- (int)stepSize
{
    return stepSize;
}

- setTotalSize: (int)value
{
   total = value;
   return self;
}

- (int)totalSize
{
   return total;
}


- setRatio:(float)newRatio
{
    if (newRatio > 1.0) newRatio = 1.0;
    if (ratio != newRatio) 
    {
        ratio = newRatio;
	count = total * ratio;
        [self display];
    }
    return self;
}

- takeFloatValueFrom: sender
{
   [self setRatio: [sender floatValue]];
   return self;
}


- setIntValue: (int) aValue
{
   [self setRatio: (float)aValue/(float)total];
   return self;
}

- (int) intValue
{
   return count;
}

- increment:sender
{
   [self setRatio:(float)(count + stepSize)/(float)total];
   return self;
}

- takeIntValueFrom: sender
{
   [self setIntValue: [sender intValue]];
   return self;
}

- (const char *)getInspectorClassName
{
    return "ProgressViewInspector";
}

- read:(NXTypedStream*)stream
{
   int readVer;

   [super read:stream];

   readVer = NXTypedStreamClassVersion(stream, [self name]);

   NXReadTypes(stream, "ii", &total, &stepSize);
   
   return self;
}

- write:(NXTypedStream*)stream
{
    [super write:stream];
    NXWriteTypes(stream, "ii", &total, &stepSize);
    return self;
}

@end





