#import <objc/Storage.h>

/*
  Copyright (c) 1992, Nicholas Christopher (nwc@gun.com)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
** StringStorage is a subclass of Storage designed to store null 
** terminated character strings. Null termination is guaranteed, therefore
** should this object's setStringValue method be called with a (char *)0
** arguement the resulting value from stringValue will be a null terminated
** empty string, i.e. "" not (char *)0.
*/

@interface StringStorage : Storage

- init;
- init: (const char *) str;

- setStringValue: (const char *) str;	     /* Set the string value */
- (const char *) stringValue;		     /* return the string pointer */

- appendStringValue: (const char *)str;	     /* append another string to the strings contents */
- appendCharValue: (char) c;		     /* append a character to the strings contents */

@end
