/*----------------------------------------------------------------------------
	Subprocess.h
	
	From Subprocess example by Charles L. Oei
									pty support by Joe Freeman
									with encouragement from Kristofer Younger
									Subprocess Example, Release 2.0
									NeXT Computer, Inc.
	
	You may freely copy, distribute and reuse the code in this example.
	NeXT disclaims any warranty of any kind, expressed or implied, as to
	its fitness for any particular use.

  This subprocess object sends/receives data to/from any UNIX
  subprocess asynchronously (via vfork/pipe).
  Its delegate, if any, will receive the following messages:

	- subprocess:sender done:(int)exitStatus;
    	sent when the subprocess exits
  
	- subprocess:sender output:(char *)buffer;
		sent whenever there is data on the standard output pipe;
		buffer is only valid until next call

	- subprocess:sender stderrOutput:(char *)buffer;
		sent whenever there is data on the standard error pipe;
		buffer is only valid until next call.

	- subprocess:sender error:(const char *)errorString;
		sent when an error occurs;
		if it ever happens, it's usually only at startup time

	REVISIONS
	Subprocess.h,v
 * Revision 1.3  1993/02/01  02:21:29  nwc
 * Added baud rate button. Cleaned interface. Fixed subprocess bug.
 *
 * Revision 1.2  1992/09/03  16:33:45  nwc
 * Clean up after Subprocesses.
 *
 * Revision 1.1.1.1  1992/08/18  14:34:20  nwc
 * GENESIS
 *
 * Revision 1.1  1992/07/04  03:17:22  nwc
 * Initial revision
 *
----------------------------------------------------------------------------*/
#import <stdio.h>
#import <objc/Object.h>

#define SUBPROCESS_STOPPED		-1
#define SUBPROCESS_SIGNALED		-2

@interface Subprocess:Object
{	
   FILE		*fpToChild;
   FILE		*fpFromChild;
   int		fromChild;
   int		stderrFromChild;
   int		childPid;
   id		delegate;
   char		outputBuffer[BUFSIZ];
   int		outputBufferLen;
   int		stderrBufferLen;
   char		stderrBuffer[BUFSIZ];
   BOOL		paused;
   BOOL		running;
   BOOL		markedForFree;		     /* free's are delayed */
}

- init:(const char *)subprocessString;
- init:(const char *)subprocessString withDelegate:theDelegate;

- setDelegate:anObject;
- delegate;
- send:(const char *)string withNewline:(BOOL)wantNewline;
- send:(const char *)string;
- (int)pid;
- (BOOL)isPaused;
- pause:sender;
- resume:sender;
- (BOOL)isRunning;
- terminate:sender;
- terminateInput;

@end

@interface Object(SubprocessDelegate)

- subprocess:sender done:(int)exitStatus;
- subprocess:sender output:(char *)buffer;
- subprocess:sender stderrOutput:(char *)buffer;
- subprocess:sender error:(const char *)errorString;

@end
