#import "InfoController.h"
#import "StringStorage.h"

@implementation InfoController

- init
{
   [super init];

   version = [[StringStorage alloc] init];
   return self;
}

- setVersionValue: (const char *)ver
{
   [version setStringValue: ver];
   return self;
}

- makeKeyAndOrderFront:sender
{
   if(!panel)
   {
      char buf[MAXPATHLEN + 1];

      [[NXBundle bundleForClass:[self class]] 
            getPath:buf  forResource: "info" ofType:"nib"];
   
      [NXApp loadNibFile:buf owner:self withNames:NO fromZone:[self zone]];
      [versionText setStringValue: [version stringValue]];
   }
   
   [panel makeKeyAndOrderFront: sender];
   return self;
}

@end
