/* pathalias -- by steve bellovin, as told to peter honeyman */

#include "defs.h"	/* include SMAIL definitions of system and ALIASDB */
#undef lowercase	/* to avoid conflict with SMAIL macro */

#ifdef UNIX_BSD
# undef SYSV_REGCMP	/* have System V style regular expression library */
# undef UNAME		/* have uname() -- probably system v or 8th ed. */
# undef MEMSET		/* have memset() -- probably system v or 8th ed. */
# define GETHOSTNAME	/* have gethostname() -- probably bsd */
# define BZERO		/* have bzero() -- probably bsd */
#endif /* UNIX_BSD */

#ifdef UNIX_SYS5
# define SYSV_REGCMP	/* have System V style regular expression library */
# define UNAME		/* have uname() -- probably system v or 8th ed. */
# define MEMSET		/* have memset() -- probably system v or 8th ed. */
# undef GETHOSTNAME	/* have gethostname() -- probably bsd */
# undef BZERO		/* have bzero() -- probably bsd */
#endif /* UNIX_SYS5 */

/**************************************************************************
 *									  *
 * +--------------------------------------------------------------------+ *
 * |									| *
 * |			END OF CONFIGURATION SECTION			| *
 * |									| *
 * |				EDIT NO MORE				| *
 * |									| *
 * +--------------------------------------------------------------------+ *
 *									  *
 **************************************************************************/

#ifdef MAIN
#ifndef lint
static char	*c_sccsid = "@(#)config.h	9.1 87/10/04";
#endif /*lint*/
#endif /*MAIN*/

/*
 * malloc/free fine tuned for pathalias.
 *
 * MYMALLOC should work everwhere, so it's not a configuration
 * option (anymore).  nonetheless, if you're getting strange
 * core dumps (or panics!), comment out the following manifest,
 * and use the inferior C library malloc/free.
 *
 * please report problems to citi!honey or honey@citi.umich.edu.
 */
#ifndef IS_ARPATXT	/* arpatxt.c doesn't want MYMALLOC */
#define MYMALLOC	/**/

#ifdef MYMALLOC
#define malloc mymalloc
#define calloc(n, s) malloc ((n)*(s))
#define free(s)
#define cfree(s)
extern char *memget();
/*
 * On some systems, the YACC parser includes malloc.h, which can cause
 * problems with the above macros.  Try to squelch this inclusion on
 * such systems by defining _MALLOC_H, which is a convention that
 * indicates that the include file should not be included "again".
 */
#ifndef _MALLOC_H
#define _MALLOC_H
#endif
#else /* !MYMALLOC */
extern char *calloc();
#endif /* MYMALLOC */
#endif /* ! IS_ARPATXT */

#ifdef BZERO
#define strclear(s, n)	((void) bzero((s), (n)))
#else /*!BZERO*/

#ifdef MEMSET
#ifndef M_XENIX
extern char	*memset();
#endif
#define strclear(s, n)	((void) memset((s), 0, (n)))
#else /*!MEMSET*/
extern void	strclear();
#endif /*MEMSET*/

#endif /*BZERO*/

extern char	*malloc();
