/*
 * @(#)includes.h 1.11 88/06/09	Copyright 1987 Free Software Foundation, Inc.
 *
 * Copying and use of this program are controlled by the terms of the
 * GNU Emacs General Public License.
 *
 * Include files for various supported systems:
 * Note that NAMESIZE should be the max length of a file name, including
 * all its directories, drive specifiers, extensions, and the like.
 * E.g. on a Unix with 14-char file names, NAMESIZE is several hundred
 * characters, since the 14-char names can be nested.
 */
#ifdef BSD
/* Unix Berserkeley systems */
#include <stdio.h>
#include <ctype.h>
#include <sys/param.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/timeb.h>
#include <sys/dir.h>
#include <sys/stat.h>

extern char *strtok();
extern char *malloc();
#define	strchr	index
#define strrchr	rindex
extern char *strchr(), *strrchr();

#define	UNIX
#define	NAMESIZE	MAXPATHLEN
#endif

#ifdef SYSV
/* Unix System V */
#include <stdio.h>
#include <ctype.h>
#include <fcntl.h>
#include <string.h>
#include <sys/types.h>
#include <sys/timeb.h>
#include <sys/stat.h>
#include <sys/dirent.h>

extern char *malloc();

#define	UNIX
#endif

#ifdef UNIX
/* Stuff common to all Unix systems */
#define	remove	unlink	/* Unix-ism for removing a file */
#define	BUFFEREDIO
#define	MULTITASK
#define	STDIN		0
#define	O_BINARY	0	/* No distinction between text and binary */
#endif

#ifdef CPM
/* CP/M-80 */
#include <stdio.h>
#include <ctype.h>
#include <fcntl.h>

#define	NAMESIZE	50		/* No directories... */
#endif

#ifdef MSDOS
/* Microsoft DOS */
#include <stdio.h>
#include <ctype.h>
#include <fcntl.h>
#include <time.h>
#include <signal.h>
#include <dos.h>
#include <conio.h>
#include <stdlib.h>
#include <process.h>
#include <string.h>

#ifdef MSC
#include <direct.h>
#include <memory.h>
#endif

#ifdef TURBOC
#include <dir.h>
#include <alloc.h>
#endif

/* Turn on support for the interrupt driven comm port routines */
#define	COMPORT

#ifdef COMPORT
#define	BUFFEREDIO
#include "comport.h"
int handler();
#endif

#define	NAMESIZE	128		/* full path size */
#endif

#ifdef ST
/* Atari ST */
#include <stdio.h>
#include <ctype.h>
#include <osbind.h>
#include <signal.h>
#include <setjmp.h>
#include <time.h>

extern char *malloc();
#define	strchr	index
#define strrchr	rindex
extern char *strchr(), *strrchr(), *strtok();

#define NAMESIZE	128	/* full path size */

#define	O_WRONLY	1	/* Open file for writing */
#define	O_APPEND	0	/* No append only mode */

#endif

#ifdef VMS

#include <ctype.h>
#include <dcdef.h>
#include <descrip.h>
#include <dvidef.h>
#include <errno.h>
#include <file.h>
#include <file>
#include <iodef.h>
#include <math.h>
#include <rmsdef.h>
#include <setjmp.h>
#include <signal.h>
#include <ssdef.h>
#include <stat.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <tt2def.h>
#include <ttdef.h>
#include <string.h>

#define NAMESIZE 255
#define	LOGCLOSE	/* Logfile must be closed; VMS locks it when open */

#define	time_t	unsigned
#define remove delete	/* Remove a file */
#define qsort pqsort	/* Our own version */

#endif

#ifdef MAC
/* Macintosh */
#include <MacTypes.h>
#include <OsUtil.h>
#include <stdio.h>
#include <ctype.h>
#include <setjmp.h>
#include <io.h>

extern char *malloc();

#define	NAMESIZE	64		/* No directories... */

#endif


#ifdef MAC_MPW
/* Macintosh Programmers Workshop. */
#include <stdio.h>
#include <ctype.h>
#include <fcntl.h>
#include <setjmp.h>
#include <uumac_mpw.h>

extern char *malloc();

#define NAMESIZE 512 /* Hat. */

#define	abort()	exit(1);
#endif

#ifdef AMIGA
#include <stdio.h>
#include <ctype.h>
#include <fcntl.h>
#include <exec/types.h>
#include <exec/exec.h>
#include <devices/serial.h>
#include <devices/keymap.h>
#include <devices/timer.h>
#include <libraries/dos.h>
#include <signal.h>

#define NAMESIZE 50

#define	bzero(area, len)	memset(area, '\0', len)
#define	bcopy(from, to, len)	memcpy(to, from, len)
#endif
