#import <appkit/appkit.h>
#import "EditListener.h"
#import <mach/mach.h>
#import <mach/message.h>
#import <servers/netname.h>
extern port_t name_server_port;
extern id NXResponsibleDelegate();
@implementation  EditListener :Listener
{}
static NXRemoteMethod *remoteMethods = NULL;
#define REMOTEMETHODS 2
+ initialize 
/* */
{
    if (!remoteMethods) {
	remoteMethods =
	(NXRemoteMethod *) malloc((REMOTEMETHODS+1)*sizeof(NXRemoteMethod));
	remoteMethods[0].key = 
	@selector(openFile:onHost:atTrueLine:);
	remoteMethods[0].types = "cci";
	remoteMethods[1].key = 
	@selector(openFile:onHost:fromTrueLine:to:);
	remoteMethods[1].types = "ccii";
	remoteMethods[REMOTEMETHODS].key = NULL;
    }
    return self;
}
-(int)openFile : (char *) fileName
	onHost : (char *) hostName
	atTrueLine : (int) line
/* */
{
    id _NXd;
    if (_NXd = NXResponsibleDelegate(self,
	@selector(openFile:onHost:atTrueLine:)))
	return [_NXd openFile : fileName
		onHost : hostName
		atTrueLine : line];
    return -1;
}

-(int)openFile : (char *) fileName
	onHost : (char *) hostName
	fromTrueLine : (int) line1
	to : (int) line2
/* */
{
    id _NXd;
    if (_NXd = NXResponsibleDelegate(self,
	@selector(openFile:onHost:fromTrueLine:to:)))
	return [_NXd openFile : fileName
		onHost : hostName
		fromTrueLine : line1
		to : line2];
    return -1;
}

- (int) performRemoteMethod : (NXRemoteMethod *) method
                  paramList : (NXParamValue *) paramList {
/* */
    switch (method - remoteMethods) {
    case 0:
	return [self openFile : paramList[0].bval.p
		onHost : paramList[1].bval.p
		atTrueLine : paramList[2].ival];
    case 1:
	return [self openFile : paramList[0].bval.p
		onHost : paramList[1].bval.p
		fromTrueLine : paramList[2].ival
		to : paramList[3].ival];
    default:
	return [super performRemoteMethod : method paramList : paramList];
    }
}
- (NXRemoteMethod *) remoteMethodFor: (SEL) aSel {
/* */
    NXRemoteMethod *rm;
    if (rm = NXRemoteMethodFromSel(aSel,remoteMethods))
        return rm;
    return [super remoteMethodFor : aSel];
}
@end
