/* Misc3DDeviceServer.h				 
 *
 * This is the basic server of the App. It manages all big abstraction
 * and manages the loading, initializing and serving.
 *
 * Usage: This is not a very reusable object. All you have to do is to
 *		  connect to the PDO port we provide and then to ask for the
 *		  devices you desire.
 *
 * Written by: 		Thomas Engel
 * Created:    		07.04.1994 (Copyleft)
 * Last modified: 	11.04.1994
 */

#import <appkit/appkit.h>

@interface Misc3DDeviceServer:Object
{
	id	deviceMatrix;
	id	mainSwapView;
 
    id	mouse;
	id	glove;
	id	display;
	id	scanner;
	id	motionTracker;
}

// Some methods need to get the app started..

- appWillInit:sender;
- appDidInit:sender;

// Those methods are used to set the relating devices inside the meta drivers.
// The set methods should not be used from the outside!!

- setMouse:aDriver;
- setGlove:aDriver;
- setDisplay:aDriver;
- setScanner:aDriver;
- setMotionTracker:aDriver;

// These methods will return the responsible driver

- mouse;
- glove;
- display;
- scanner;
- motionTracker;

@end

/*
 * History: 11.04.94 Included the meta drivers.
 *
 *			09.04.94 Added the PDO port and some more device methods.
 *
 *			07.04.94 My first try. Just to get it running.
 *
 *
 * Hints: I will need to redesign this a lot.
 *			- loading adaptors from bundles.
 *			- setting up a (BB)or Misc3DDevice -> Misc3DMouse hirarchie.
 *
 *		  The current design has some 'problems' with changing the driver
 *		  while it is used. It does not get a disconnect msg. etc.
 *		  I should switch to returning metadrivers in the final release.
 *		  This way I could change the device with having a problem that
 *		  the apps refer to the wrong driver when they sync etc. they should
 *		  therefore refer to the [.. realDriver ]; !!!
 *
 * Bugs: - Yes
 */