/* DEMPROC.C Copyright 1994 Steve Ludtke */
/* This program reads a DEM (digital elevation model) file and writes it */
/* in a more compact easier to search form (pdem) for use with NXPlot3d  */

#include<stdio.h>
#include<math.h>

float flread(char *s,int *p);

int blmode;		// if 0 fixed length mode, if 1 variable length mode

main(int argc,char *argv[])
{
char s[10241];
int i,j,jj,k,l,m,p,nx,ny;
short h[20];
float a,b,c,xm[2],ym[3],zm[2];
FILE *in,*out;

if (argc!=3) { printf("demproc <infile>.dem <outfile>.pdem\n"); exit(0); }
in=fopen(argv[1],"r");
if (in==NULL) { printf("Can't open input file\n"); exit(0); }

out=fopen(argv[2],"w");
if (out==NULL) { printf("Can't open output file\n"); exit(0); }

fread(s,1024,1,in);
for (i=0; i<1024; i++) if (s[i]=='\n') break;
if (i==1024) {
	blmode=0; 
	printf("This is a fixed record length DEM\n");
}
else {
	blmode=1;
	printf("This is a variable record length DEM\n");
}

rewind(in);
if (blmode) fgets(s,10240,in); else fread(s,1024,1,in);

sscanf(&s[0x214],"%d %d %d",&i,&j,&k);
if (i!=3) printf("Unknown units. Expected arc-seconds, got %d\n",i);
else printf("x/y units are arc-seconds\n");
if (j==2) printf("z units are meters\n");
else if (j==1) printf("z units are feet\n");
else printf("Unknown units. Expected meters=2 or feet=1, got %d\n",j);
if (k!=4) printf("Bad polygon. I expected 4, I got %d\n",k);

p=0x223;
a=flread(s,&p);
b=flread(s,&p);
xm[0]=a/3600.0;
ym[0]=b/3600.0;

a=flread(s,&p);
b=flread(s,&p);
a=flread(s,&p);
b=flread(s,&p);
xm[1]=a/3600.0;
ym[1]=b/3600.0;

a=flread(s,&p);
b=flread(s,&p);
a=flread(s,&p);
b=flread(s,&p);
printf("The elevations in this file vary from %f to %f\n",a,b);
zm[0]=a;
zm[1]=b;

printf("This map covers an area from %f,%f to %f,%f\n",xm[0],ym[0],xm[1],ym[1]);

sscanf(&s[0x358]," %d %d",&i,&j);
printf("There are %dX%d profiles in this file\n",i,j);
nx=j;
if (i!=1) { printf("I only know how to read 1Xn files. Sorry\n"); exit(0); }

printf("Pass 1, check row count limits\n");
for (i=ny=0; i<nx; i++) {
	if (blmode) fgets(s,10240,in); else fread(s,1024,1,in);
	sscanf(s," %d %d %d %d%n",&j,&j,&jj,&k,&p);
	a=flread(s,&p);
	a=flread(s,&p);
	a=flread(s,&p);
	a=flread(s,&p);
	a=flread(s,&p);
	if (jj>ny) {
		ny=jj;
		printf("Scan row %d, %d points\n",i,jj);
	}
	if (k!=1) { 
		printf("\nHmm, I can't process %d rows per col\n",k); 
		s[1024]=0;
		puts(s);
		exit(0); 
	}

	k=(jj*6+p)/1024;
	if (blmode) { for (j=0; j<k; j++) fgets(&s[strlen(s)],1024,in); }
	else fread(&s[1024],1024,k,in);
}

fwrite(&nx,4,1,out);	/* write 32 byte file header */
fwrite(&ny,4,1,out);
fwrite(xm,4,2,out);
fwrite(ym,4,2,out);
fwrite(zm,4,2,out);
ym[2]=(ym[1]-ym[0])/(float)(ny-1);

rewind(in);
if (blmode) fgets(s,10240,in); else fread(s,1024,1,in);

printf("Pass 2, convert data\n");
for (i=m=0; i<nx; i++) {
	if (blmode) fgets(s,10240,in); else fread(s,1024,1,in);
	sscanf(s," %d %d %d %d%n",&j,&j,&jj,&k,&p);
	p++;
	b=flread(s,&p);
	a=flread(s,&p)/3600.0;
	b=flread(s,&p);
	b=flread(s,&p);
	b=flread(s,&p);
	printf("Scan row %d, %d points\r",i,jj);
	fflush(stdout);

	k=(jj*6+p)/1024;
	if (blmode) { for (j=0; j<k; j++) fgets(&s[strlen(s)],1024,in); }
	else fread(&s[1024],1024,k,in);
	s[1024*(k+1)]=0;

	// need padding Zmin data if the row is incomplete
	if (ny!=jj) {
		m=(a-ym[0])/ym[2];
		if (jj+m>ny) m=ny-jj;
		if (m<0) m=0;
		printf("Scan row %d, %d/%d points incomplete, pad=%d, %f\n",i,jj,ny,m,a);
		h[0]=zm[0];
		for (j=0; j<m; j++) fwrite(h,2,1,out);
	}
	else m=0;

	for (j=0; j<jj; j+=l) {
		l=sscanf(&s[p]," %hd %hd %hd %hd %hd %hd %hd %hd %hd %hd %hd %hd %hd %hd %hd %hd %hd %hd %hd %hd%n", &h[0],&h[1],&h[2],&h[3],&h[4],&h[5],&h[6],&h[7],&h[8],&h[9],&h[10],&h[11],&h[12],&h[13],&h[14],&h[15],&h[16],&h[17],&h[18],&h[19],&k); 
		p+=k;
		m+=l;
		fwrite(h,2,l,out);
	}

	// fill in Zmin for rest of row
	h[0]=zm[0];
	for (j=m; j<ny; j++) fwrite(h,2,1,out);
}

}

float flread(char *s,int *p)
{
int i;
char m[30],e[10];
float r1,r2;

i=0;
while (s[*p]!='D' && s[*p]!='E' && s[*p]!='d' && s[*p]!='e' && i<30) {
	m[i++]=s[*p];
	(*p)++;
}
if (i==30) return(0);
m[i]=0;
(*p)++;

e[0]=s[*p];
e[1]=s[*p+1];
if (s[*p]=='+' || s[*p]=='-') {
	e[2]=s[*p+2];
	e[3]=0;
	(*p)+=3;
}
else { e[3]=0; (*p)+=2; }

sscanf(m," %f",&r1);
sscanf(e," %f",&r2);
return(r1*pow(10.0,r2));
}
