/* Plot3dView.h   Copyright 1992 Steve Ludtke */
#import <3Dkit/N3DCamera.h>

#define SS .01		/* symbol size. 1.0 would cause the symbols to be */
			/* as large as the view */
#define MAXSETS 5	/* maximum number of sets, changing this number */
			/* requires IB changes as well */
#define NFN 5		/* currently this is redundant. Number of active */
			/* data sets */
#define TIMESTEP .1	/* Time in sec between updates */

#define MAXGRID 250	/* maximum x and y grid components */

/* 3d point structure */
typedef struct {
	float x,y,z;
} Point;

#define MM_none 0
#define MM_height 1
#define MM_grad	2
#define MM_nextset 3

#define OVER_surf	1
#define OVER_base	2
#define OVER_csurf	4

#define RF_axis		1
#define RF_backs	2
#define RF_floor	4
#define RF_ticks	8
#define RF_planes	16
#define RF_labels	32
#define RF_persp	64

#define F_EQN	1
#define F_DATA	2
#define F_SDATA	3
#define F_DEM	4	/* digital elevation map */

/* data set preferences structure (incudes pointer to actual data) */
typedef struct {
	char sym;		/* -1 means don't plot, else 0<=sym<=7 */
	Point *fileData;	/* data from a file, NULL if equation mode */
	Point *data;		/* data to be displayed. In file mode it */
						/* contains the visible subset of the data */
	Point *Sdata;		/* Spherical data to be displayed (mode 7) */
	RtColor *color;
	short *demData;		/* raw DEM data */
	float demx[3],demy[3],demz[2];	/* dem data limits */
	int demnx,demny;				/* dem mesh size */
	int flag;
	int nfdata;		/* # points in file data */
	int ndata;		/* # points in data */
	int nx,ny;		/* grid points in x and y */
	id expr;		/* points to the Expression (formula eval.) */
	RtColor mapcol[5];
	float alpha;
	unsigned char mapsel[5];
	short mapmode;
} SetPref;

/* timer for spinning, etc ... */
DPSTimedEntry timer;
void itstime(DPSTimedEntry entry,double now,id call);

@interface Plot3DView:N3DCamera
{
id mode;		/* mouse mode selector */
id controller;		/* points to PControl */
id shape;			/* shape containing 3d plot */
id ambLight;
id aLight;
id varT;		/* variable text matrix */
id flagSel;
id autotick;	/* flag for automatic tick spacing generation */
id tickpos;		/* matrix of tick values */
id axisTitle;	/* matrix of axis titles */ 
id aspectS;
id fontSize;	/* font size selector */
float chi,theta,phi,dchi;	/* viewing angles/speeds */
float lchi,ltheta;		/* light angle */
float ambient;			/* ambient light level */
float minX,maxX;	/* current min/max values */
float minY,maxY;
float minZ,maxZ;
float aspect;		/* x,y/z aspect */
RtColor flagcol[5];
RtPoint Tick0,Tick1,Tick00,Tick01;		/* tick min/max for x-fer to shape */
int Rmode,Rflags,Omode;
char pscom[1000];	/* postscript buffer for DPSUserPath */
float pspath[3000];	/* increases drawing speed substantially */
float psbbox[4];
int psc;		/* counter for user path */
char initflag;		/* flag so timer knows the first time it's called */
SetPref pref[MAXSETS];	/* preferences for data sets */
}


-initFrame:(NXRect *)myrect;
-free;

/* rescales coord. system after size chaged */
-superviewSizeChanged:(const NXSize *)oldsize;

/* draw 3d plot */
-drawPS:(NXRect *)myrect :(int)rectCount;

/* change viewing angle */
-setAng:(float)theta :(float)chi;

/* change phi */
-setPhi:sender;

/* used to do mouse zooming and spinning */
-mouseDown:(NXEvent *)event;

/* points to controller object, usually set with IB instead */
-setcontroller:del;

/* called by timer to do one time step */
-step;

-(int)acceptsFirstMouse;

/* recalculate and display plot (and density plot, via controller) */
-zoom:sender;

/* change min/max values */
-zoomTo:(float)minx :(float)miny :(float)maxx :(float)maxy;

/* toggles dchi=0 on and off */
-togFreeze:sender;

/* Makes a surface map for a rib file*/
-makeSMap:sender;

/* dump .rib file from 3d view */
- dumpRib:sender;

/* currently does nothing */
- renderSelf:(RtToken)context;

/* sets intensity of ambient light */
- setAmbLight:sender;

/* sets intensity of distant light */
- setLight:sender;

/* sets chi of distant light */
- setLightX:sender;

/* sets theta of distant light */
- setLightY:sender;

/* sets rendering mode */
- setMode:sender;

/* prints window with white background */
- printPSCode:sender;

/* set drawing flags */
-setFlags:sender;

/* set overlay flags */
-setOverlay:sender;

-setFlagColor:sender;

-size320:sender;

-setEye:sender;

-setAsp:sender;

/* set perspective or orthographic projection */
-setProj:sender;

-tickCalc:(float)n :(float)x0 :(float)x1 :(float *)min :(float *)spa;

-(float)getTheta;

-(float)getChi;

-PRTiff:sender;

- renderTIFF:(char *)fsp;

/* reset aspect to 1:1 */
- aspect11:sender;
@end
