#define	TABLESIZE 4096

struct _point
{
  float xcoor;
  float ycoor;
  float zcoor;
};
typedef struct _point point;

struct edge {
  float p[3], p1;
  int axis;
  float pcross;
  int used;
  int index;
  struct edge *link;
  struct edge *prev;
  struct edge *prevPoint;
};

struct face {
  int numEdges;
  struct face *prev;
};

struct edgeList {
  struct edge *edge;
  struct edgeList *prev;
};

typedef struct Surface {
  int numVert, numPoly, numTotal;
  struct face *face;
  struct edgeList *edge;
  struct edge *lastEdge; 
  struct face *lastFace;
  struct edgeList *lastE;
  struct edge *hashtable[TABLESIZE];
} Surface;

typedef float (*SurfaceFunc)(float x, float y, float z);

extern Surface *algsurf(float xmin, float ymin, float zmin, 
              float xmax, float ymax, float zmax, 
	      int N, SurfaceFunc f, float M);
