/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef APPEARANCEDEF
#define APPEARANCEDEF

/*
  #define AP_IDEBUG before #including this file to compile for
  debugging
*/

#include "ooglutil.h"
#include "vert.h"
#include "3d.h"
#include "color.h"
#include "handle.h"
#include <stdarg.h>

#define DONE 1
#define ANOTHER 2

typedef struct LtLight {
    struct LtLight *next;
    Color ambient;
    Color color;
    Point position;		/* application-specified light position */
    Point globalposition;	/* real light position; set & used only by mg */
    float intensity;

    int Private;		/* private part; used only by mg */

    short location;		/* How to interpret the "position": */
#define	LTF_GLOBAL	0x0		/* global coordinate system */
#define	LTF_CAMERA	0x1		/* camera coordinates */
#define	LTF_LOCAL	0x2		/* local coordinates
					 * where appearance is attached. */

    short changed;
} LtLight;


typedef struct LmLighting {
    REFERENCEFIELDS
    int valid, override;	 /* LMF_* inheritance bits */
    Color ambient;
    int	localviewer;
    float attenconst, attenmult, attenmult2;
    LtLight *lights;

    int Private;
    int changed;
} LmLighting;


typedef struct Material {
    REFERENCEFIELDS
    int valid, override;	/* MTF_* inheritance bits */
    Color emission;
    Color ambient;
    Color diffuse;
    float alpha;
    Color specular;
    float shininess;
    float ka, kd, ks;
    Color edgecolor;		/* Color for polygon edges and other vectors */
    Color normalcolor;		/* Color for surface-normal vectors */

    int Private;
    int changed;
} Material;

typedef struct Appearance {
    REFERENCEFIELDS
    Material	*mat, *backmat;	    /* material properties */
    LmLighting	*lighting;  /* attached lighting */
    unsigned int flag;	    /* APF_* shading,faces/edges,normals,transparency */
    unsigned int valid;	    /* APF_* bits control inheritance of these fields */
    unsigned int override;  /* same APF_* flags: parent overrides child */
    float nscale;	    /* scale factor for drawing normals */
    int linewidth;          /* how wide do lines appear (pixels) ? */
    int shading;	    /* APF_{CONSTANT,FLAT,SMOOTH} */
}  Appearance;



/* the following tokens are used in LtSet and LtGet */
#define LT_END		700
#define	LT_AMBIENT	701	/* Color ambient */
#define	LT_COLOR	702	/* Color color */
#define	LT_POSITION	703	/* Point position */
#define	LT_INTENSITY	704	/* double intensity */
#define	LT_LOCATION	705	/* int location: LTF_{GLOBAL,CAMERA,LOCAL} */

#define LT_ABLOCK	706	/* void **ablock */


/* the following tokens are used in LmSet and LmGet */
#define LM_END		  600	
#define	LM_AMBIENT	  601	/* Color ambient */
#define	LM_LOCALVIEWER	  602	/* int localviewer */
#define	LM_ATTENC	  603	/* double attenconst */
#define	LM_ATTENM	  604	/* double attenmult */
#define	LM_ATTEN2	  612	/* double attenmult2 */
#define LM_LtSet	  605	/* ... */
#define LM_LIGHT	  606	/* LtLight *light */
#define LM_VALID	  607	/* int mask (Get only) */
#define LM_INVALID	  608	/* int mask (unsets valid bits) */
#define LM_OVERRIDE	  609	/* int mask (sets override bits) */
#define LM_NOOVERRIDE	  610	/* int mask (unsets override bits) */
#define LM_REPLACELIGHTS  611	/* int replace */

#define LM_ABLOCK	  613	/* void **ablock */


/* the following tokens are used in MtSet and MtGet */
#define MT_END		500	
#define MT_EMISSION	501	/* Color *emission */
#define	MT_AMBIENT	502	/* Color *ambient */
#define	MT_DIFFUSE	503	/* Color *diffuse */
#define	MT_SPECULAR	504	/* Color *specular */
#define	MT_Ka		505	/* double ka */
#define	MT_Kd		506	/* double kd */
#define	MT_Ks		507	/* double ks */
#define	MT_ALPHA	508	/* double alpha */
#define	MT_SHININESS	509	/* double shininess */
#define	MT_EDGECOLOR	510	/* Color *edgecolor (for edges & vectors) */
#define	MT_NORMALCOLOR	511	/* Color *normalcolor (for surface normals) */
#define MT_VALID	512	/* int mask (Get only) */
#define MT_INVALID	513	/* int mask (unsets valid bits) */
#define MT_OVERRIDE	514	/* int mask (sets override bits) */
#define MT_NOOVERRIDE	515	/* int mask (unsets override bits) */

#define MT_ABLOCK	516	/* void **ablock */


/* the following tokens are used in ApSet and ApGet */
#define AP_END		400	
#define AP_DO		401	/* int mask (set flag bits) */
#define AP_DONT 	402	/* int mask (unset flag bits) */
#define AP_MAT		403	/* Material *mat */
#define AP_MtSet	404	/* ... */
#define AP_LGT		405	/* LmLighting *lgt */
#define AP_LmSet	406	/* ... */
#define AP_NORMSCALE	407	/* float nscale */
#define AP_LINEWIDTH	408	/* int linewidth */
#define AP_VALID	409	/* int mask (Get only) */
#define AP_INVALID	410	/* int mask (unsets valid bits) */
#define AP_OVERRIDE	411	/* int mask (sets override bits) */
#define AP_NOOVERRIDE	412	/* int mask (unsets override bits) */
#define AP_SHADING	413	/* int shading (set to APF_{CONSTANT,FLAT,SMOOTH} */
#define	AP_BACKMAT	414	/* Material *backmaterial */

#define AP_ABLOCK	415	/* void **ablock */

				/* Flags to ApMerge, etc. */
#define	APF_INPLACE	 0x1	/* Merge in place */
#define	APF_OVEROVERRIDE 0x2	/* src replaces dst even without src override */


#ifndef AP_IDEBUG
Appearance *	ApCreate( int attr, ... );
Appearance *	ApSet( Appearance *ap, int attr, ... );
#endif
Appearance *	_ApSet(Appearance *ap, int attr1, register va_list *alist);
int		ApGet( Appearance *ap, int attr, void *valuep );
void		ApDelete( Appearance *ap );
Appearance *	ApDefault( Appearance *ap );
Appearance *	ApCopy( Appearance *from, Appearance *into );
Appearance *	ApMerge( Appearance *src, Appearance *dst, int inplace );
Appearance *	ApFLoad( Appearance *into, FILE *f, char *stream );
Appearance *	ApLoad( Appearance *into, char *stream );

		/* Force 'override' bits on (for all valid fields)
		 * or off, in an Appearance.
		 */
void 	ApUseOverrides( Appearance *ap, int use_overrides );

		/* Erase fields in 'dst' corresponding to any in 'src';
		 * allows 'src' settings to propagate through 'dst',
		 * when 'dst' is its child.
		 */
void	ApLetPropagate( Appearance *src, Appearance *dst );

#ifndef AP_IDEBUG
Material *	MtCreate( int attr, ... );
Material *	MtSet( Material *, int attr, ... );
#endif
int		MtGet( Material *, int attr, void *valuep );

void		MtDelete( Material * );
Material *	MtDefault( Material * );
Material *	MtLoad( Material *, char *filename );
Material *	MtCopy( Material *from, Material *into );
Material *	MtMerge( Material *src, Material *dst, int inplace );
Material *	MtFLoad( Material *into, FILE *stream, char *filename );
int		MtSave( Material *, char *filename );
int		MtFSave( Material *mat, FILE *stream );
void		MtPrint( Material * );


#ifndef AP_IDEBUG
LtLight *	LtCreate( int attr, ... );
LtLight *	LtSet( LtLight *, int attr, ... );
#endif
int		LtGet( LtLight *, int attr, void *valuep );
void 		LtDelete( LtLight * );
LtLight *	LtCopy( LtLight *, LtLight * );
LtLight *	LtMerge( LtLight *, LtLight * );
LtLight *	LtDefault( LtLight * );
void 		LtProperties( LtLight *, float, Color *, Point * );
LtLight *     	LtLoad( LtLight *, char *filename);
LtLight *     	LtFLoad( LtLight *, FILE *, char *filename);
void 		LtRemove( LmLighting *, LtLight * );
void 		LtAppend( LmLighting *, LtLight * );
LtLight *	LtCopylist(LtLight *l, int mergeflag);
void		LtDeletelist(LtLight *l);


#ifndef AP_IDEBUG
LmLighting *	LmCreate( int attr, ... );
LmLighting *	LmSet( LmLighting *, int attr, ... );
#endif
int		LmGet( LmLighting *, int attr, void *valuep );
void 		LmDelete( LmLighting * );
void 		LmDelete( LmLighting * );
void 		LmDefault( LmLighting * );
LmLighting * 	LmLoad( LmLighting *, char *filename );
LmLighting *	LmFLoad( LmLighting *, FILE *, char *filename );
void 		LmSave( LmLighting *, char *filename );
int 		LmFSave( LmLighting *, FILE *, char *filename );
LmLighting *	LmMerge( LmLighting *src, LmLighting *dst, int inplace );
LmLighting *	LmCopy( LmLighting *src, LmLighting *dst );

#define	LIGHTINGMAGIC	OOGLMagic('l', 1)

#define	LMF_LOCALVIEWER	0x1   /* Local viewer (flag valid) */
#define	LMF_AMBIENT	0x2   /* Ambient light color */
#define	LMF_ATTENC	0x4   /* attenuation constant factor */
#define	LMF_ATTENM	0x8   /* attenuation linear factor */
#define	LMF_ATTEN2	0x20  /* 1/r^2 attenuation factor */
#define	LMF_REPLACELIGHTS	0x10  /* When merging, use only new lights, not union */

#define	MATMAGIC	OOGLMagic('m', 1)

#define MTF_EMISSION	0x1
#define	MTF_AMBIENT	0x2
#define	MTF_DIFFUSE	0x4
#define	MTF_SPECULAR	0x8
#define	MTF_Ka		0x10
#define	MTF_Kd		0x20
#define	MTF_Ks		0x40
#define	MTF_ALPHA	0x80
#define	MTF_SHININESS	0x100
#define	MTF_EDGECOLOR	0x200
#define	MTF_NORMALCOLOR	0x400


#define	APMAGIC		OOGLMagic('a', 1)

/* The following bits are used in 'flag', 'valid', 'override' */
#define	APF_FACEDRAW	0x2	/* Draw faces */
#define	APF_EDGEDRAW	0x10	/* Draw edges */
#define	APF_TRANSP	0x20	/* Enable transparency */
#define	APF_EVERT	0x40	/* Evert surface normals */
#define	APF_NORMALDRAW	0x80	/* Draw surface normals */
#define	APF_VECTDRAW	0x100	/* Draw vectors/points */

/* The following bits are used in 'valid', 'override' */
#define	APF_SHADING	0x1     /* Use 'shading' value */
#define	APF_NORMSCALE	0x4	/* Use 'nscale' value to draw normals */
#define	APF_LINEWIDTH	0x8	/* Use 'linewidth' value  */

/* Possible values for ap->shading field; these MUST be consecutive !!
   (code outside the appearance library depends on this fact) */
#define	APF_CONSTANT	0	/* constant-colored (unlighted) faces */
#define APF_FLAT	1	/* Flat-shaded, lighted faces */
#define	APF_SMOOTH	2	/* Gouraud-shaded faces, with lighting */
#define	APF_CSMOOTH	3	/* Gouraud-shaded faces, without lighting */

#define	IS_SMOOTH(shading)  ((shading) >= APF_SMOOTH)
#define	IS_SHADED(shading)  ((1<<(shading)) & ((1<<APF_FLAT)|(1<<APF_SMOOTH)))


#ifdef AP_IDEBUG

Appearance *	ApCreate();
Appearance *	ApSet();
Material *	MtCreate();
Material *	MtSet();
LtLight *	LtCreate();
LtLight *	LtSet();
LmLighting *	LmCreate();
LmLighting *	LmSet();

int lt_end = LT_END;
int lt_ambient = LT_AMBIENT;
int lt_color = LT_COLOR;
int lt_position = LT_POSITION;
int lt_intensity = LT_INTENSITY;

int lm_end = LM_END;
int lm_ambient = LM_AMBIENT;
int lm_localviewer = LM_LOCALVIEWER;
int lm_attenc = LM_ATTENC;
int lm_attenm = LM_ATTENM;
int lm_ltset = LM_LtSet;
int lm_light = LM_LIGHT;
int lm_valid = LM_VALID;
int lm_invalid = LM_INVALID;
int lm_override = LM_OVERRIDE;
int lm_nooverride = LM_NOOVERRIDE;

int mt_end = MT_END;
int mt_emission = MT_EMISSION;
int mt_ambient = MT_AMBIENT;
int mt_diffuse = MT_DIFFUSE;
int mt_specular = MT_SPECULAR;
int mt_ka = MT_Ka;
int mt_kd = MT_Kd;
int mt_ks = MT_Ks;
int mt_alpha = MT_ALPHA;
int mt_shininess = MT_SHININESS;
int mt_valid = MT_VALID;
int mt_invalid = MT_INVALID;
int mt_override = MT_OVERRIDE;
int mt_nooverride = MT_NOOVERRIDE;

int ap_end = AP_END;
int ap_do = AP_DO;
int ap_dont = AP_DONT ; 
int ap_mat = AP_MAT;
int ap_mtset = AP_MtSet;
int ap_lgt = AP_LGT;
int ap_lmset = AP_LmSet;
int ap_normscale = AP_NORMSCALE;
int ap_linewidth = AP_LINEWIDTH;
int ap_valid = AP_VALID;
int ap_invalid = AP_INVALID;
int ap_override = AP_OVERRIDE;
int ap_nooverride = AP_NOOVERRIDE;
int ap_shading = AP_SHADING;

int lmf_localviewer = LMF_LOCALVIEWER;
int lmf_ambient = LMF_AMBIENT;
int lmf_attenc = LMF_ATTENC;
int lmf_attenm = LMF_ATTENM;
int lmf_replacelights = LMF_REPLACELIGHTS;

int mtf_emission = MTF_EMISSION;
int mtf_ambient = MTF_AMBIENT;
int mtf_diffuse = MTF_DIFFUSE;
int mtf_specular = MTF_SPECULAR;
int mtf_ka = MTF_Ka;
int mtf_kd = MTF_Kd;
int mtf_ks = MTF_Ks;
int mtf_alpha = MTF_ALPHA;
int mtf_shininess = MTF_SHININESS;

int apf_facedraw = APF_FACEDRAW;
int apf_edgedraw = APF_EDGEDRAW;
int apf_transp = APF_TRANSP;
int apf_evert = APF_EVERT;

int apf_shading = APF_SHADING;
int apf_normscale = APF_NORMSCALE;
int apf_linewidth = APF_LINEWIDTH;

int apf_constant = APF_CONSTANT;
int apf_flat = APF_FLAT;
int apf_smooth = APF_SMOOTH;

#endif /* AP_IDEBUG */

void ApFSave( Appearance *ap, Handle *aphandle, FILE *f, char *fname );
int ApStreamIn(Pool *p, Handle **hp, Appearance **app);
int ApStreamOut(Pool *p, Handle *h, Appearance *ap);

#endif /* APPEARANCEDEF */


