/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef HPOINT3DEF
#define HPOINT3DEF


#include "point3.h"

typedef float HPt3Coord;
typedef struct { HPt3Coord x, y, z, w; } HPoint3;

extern HPoint3 *HPt3Create();
extern void HPt3Delete(/* HPoint3 *pt */);

extern void HPt3Print(/* HPoint3 *pt */);
extern void HPt3Copy(/* HPoint3 *pt1, *pt2 */);
extern void HPt3Add(/* HPoint3 *pt1, *pt2, *pt3 */);
extern void HPt3From(/* HPoint3 *pt, HPt3Coord x, y, z, w */);
extern int HPt3From3HPl3s(/* HPoint3 *pt, HPlane3 *pl1, *pl2, *pl3 */);
extern int HPt3From2HLn3s(/* HPoint3 *pt, HLine3 *ln1, *ln2 */);

extern int HPt3IntersectHPt3(/* HPoint3 *pt1, *pt2, HLine3 *ln */);
extern void HPt3Pencil(/*HPt3Coord t1,HPoint3 pt1,HPt3Coord t2,HPoint3 *pt2,*pt*/);

extern float HPt3DotHPl3(/* HPoint3 *pt, HPlane3 *pl */);

extern void HPt3Normalize(/* HPoint3 *pt1, *pt2 */);

extern int HPt3Undefined(/* HPoint3 *pt */);
extern int HPt3Infinity(/* HPoint3 *pt */);
extern int HPt3Compare(/* HPoint3 *pt1, *pt2 */);

extern int HPt3CoincidentHPt3(/* HPoint3 *pt1, *pt2 */);
extern int HPt3CoincidentHLn3(/* HPoint3 *pt, HLine3 *ln */);
extern int HPt3CoincidentHPl3(/* HPoint3 *pt, HPlane3 *pl */);

extern void HPt3Transform(/* Transform3 T, HPoint3 *pt1, *pt2*/);
extern void HPt3TransformN(/* Transform3 T, HPoint3 *pt1, *pt2, int n*/);
extern HPt3Coord HPt3TransPt3( /*Transform3 T, HPoint3 *from, Point3 *into*/ );
extern void Pt3ToPt4( /*Point3 *src, HPoint3 *dst, int npoints */ );
extern void HPt3ToPt3( /*HPoint3 *src, Point3 *dst*/ );
extern void HPt3Dehomogenize( /*HPoint3 *src, HPoint3 *dst*/ );

extern void HPt3Dual(/* HPoint3 *pt, HPlane3 *pl */);

extern void HPt3LinSum(/*HPt3Coord scale1,HPoint3 *in1,HPt3Coord scale2, HPoint3 *in2, *out */);
extern void HPt3SizeOne (/* HPoint3 *pt, *out */);

extern HPt3Coord HPt3R40Dot(HPoint3 *a, HPoint3 *b);
extern HPt3Coord HPt3R31Dot(HPoint3 *a, HPoint3 *b);
extern HPt3Coord HPt3R30Dot(HPoint3 *a, HPoint3 *b);
extern HPt3Coord HPt3SpaceDot(HPoint3 *a, HPoint3 *b, int space);
extern void HPt3R40Normalize(HPoint3 *a);
extern void HPt3R31Normalize(HPoint3 *a);
extern void HPt3R30Normalize(HPoint3 *a);
extern void HPt3SpaceNormalize(HPoint3 *a, int space);
extern HPt3Coord HPt3HypDistance(HPoint3 *a, HPoint3 *b);
extern HPt3Coord HPt3Distance( HPoint3 *a, HPoint3 *b );
extern HPt3Coord HPt3SphDistance(HPoint3 *a, HPoint3 *b);
extern HPt3Coord HPt3SpaceDistance(HPoint3 *a, HPoint3 *b, int space);
extern void HPt3Sub(HPoint3 *a, HPoint3 *b, HPoint3 *aminusb);
extern void HPt3Scale(HPt3Coord s, HPoint3 *a, HPoint3 *sa);
extern HPt3Coord HPt3HypAngle(HPoint3 *base, HPoint3 *v1, HPoint3 *v2);
extern void HPt3SpaceGramSchmidt(HPoint3 *base, HPoint3 *v, int space);
extern void HPt3SubPt3(register HPoint3 *p1, register HPoint3 *p2, register Point3 *v);
extern void HPt3SphGramSchmidt(HPoint3 *base, HPoint3 *v);
extern void HPt3HypGramSchmidt(HPoint3 *base, HPoint3 *v);
#endif
