/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef INSTDEFS
#define INSTDEFS

/*
 * Private definitions for Inst's.
 */

#include "bbox.h"

typedef struct Inst Inst;

extern GeomClass *InstClass;		/* Public read-only; valid only
					 * after first call to InstMethods()
					 */

extern GeomClass *InstMethods( void );

extern Geom *InstImport( Pool *p );
extern int   InstExport( Inst *, Pool * );
extern int   InstGet( Inst *, int attr, void *attrp );
extern Inst *InstLoad( char * );
extern Inst *InstFLoad( FILE *, char *name );
extern Inst *InstSave( Inst *, char * );
extern Inst *InstFSave( Inst *, FILE *, char * );
extern BBox *InstBound( Inst *, Transform T );
extern Geom *InstBoundSphere( Inst *, Transform T, int );
extern Inst *InstPosition( Inst *, Transform T );
extern Inst *InstTransformTo( Inst *, Transform T );
extern Inst *InstTransform( Inst *, Transform T );
extern Inst *InstEvert( Inst * );
extern Inst *InstDraw( Inst * );
extern Geom *InstReplace( Inst *, Geom * );

#endif /*INSTDEFS*/
