/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */


/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

/*
 * Public interface to XGL version of mg library.
 */

/*
 * XGL-specific mgctxcreate(), mgctxset(), mgctxget() attributes.
 * None are required, but may be supplied for extra control.
 *
 *	MG_XWINDOW		X window id to render XGL into.
 *				If set, XGL uses X11 rather than XView.
 *				Note: MG_XDISPLAY required if MG_XWINDOW used!
 *				Default: use XView instead.
 *
 *	MG_XDISPLAY		Xlib Display *pointer* [not int index!]
 *				Must be supplied if MG_XWINDOW set.
 *
 *	MG_XSCREEN		window's integer screen number on X display.
 *				Default: Display's default screen
 *
 *
 *	MG_REPAINT_PROC		called when redraw necessary.  Default
 *				redraw routine sets "MG_REPAINT" attribute to 1.
 *				[mgworldbegin() resets MG_REPAINT to 0.]
 *				[What args should be passed?]
 *
 *	MG_RESIZE_PROC		called when window has been resized
 *				by the window manager.  Default routine
 *				sets MG_RESIZE attribute to 1 and calls
 *				mgreshapeviewport().
 *				
 *
 *	MG_XGL_STATE		XGL state as returned by xgl_open().
 *				XGL requires that xgl_open be called just once
 *				per process.  If caller has already called it,
 *				you should pass the resulting state in to mg.
 *				If not supplied, mg library calls xgl_open().
 *
 */

				/* X11 parameters */

#define	MG_XWINDOW	140		/* Window (int, from Xlib) */
#define	MG_XDISPLAY	141		/* Display * (Xlib Display pointer) */
#define	MG_XSCREEN	142		/* int (integer screen number) */

				/* XView parameters */

#define	MG_XV_FRAME	144		/* Frame (from XView) */
#define	MG_XV_CANVAS	145		/* Canvas (from XView) */
#define	MG_XV_WINDOW	146		/* Xv_Window win (not X11 Window id) */
					/*	 (the "canvas paint window") */
#define	MG_XV_RASTER	147		/* Xgl_win_ras  (XGL Raster handle)  */

#define	MG_REPAINT_PROC 148		/* void (*proc)()  time to repaint */
#define	MG_RESIZE_PROC	149		/* void (*proc)()  window resized */

				/* Miscellany */

#define	MG_REPAINT	150		/* int repaint_requested_by_xview */
#define	MG_RESIZE	151		/* int resized_by_xview */
#define	MG_XGL_STATE	152		/* Xgl_sys_state */


/*
 * XGL-specific routines
 */

extern mgcontext *mgxgl_findctxbywin( int x11win );
