/*
 * MG context attributes specific to Quick Renderman
 *
 */

#define   MG_RIWINID		101
#define   MG_RIBORN		102

#define   MG_NXWINDOW		114
#define   MG_NXVIEW		115
#define   MG_RIWINDOW		116
#define   MG_RICALLBACK		117
#define   MG_RISTANDALONE       118

/* callback attributes (not context attributes!) */
#define   MG_RIWINDOWICONIFIED		0
#define   MG_RIWINDOWDEICONIFIED	1
#define   MG_RIWINDOWEXPOSED		2 /* use with nonretained windows? */
#define   MG_RIWINDOWRESIZED		3
#define   MG_RIWINDOWCLOSED  		4
#define   MG_RIWINDOWBECAMEKEY		5
#define   MG_RIWINDOWBECAMEMAIN		6

/* Context Attributes
 * MG_RIWINID		mg window id
 * MG_RIBORN		window has been created
 * MG_NXWINDOW		associated OBJC window id
 * MG_NXVIEW		associated OBJC view id
 * MG_RIWINDOW		?
 * MG_RICALLBACK	used with callback functios (see below)
 * MG_RISTANDALONE	set if events processed automatically in mg_worldend
 * 			(if your application will do NeXTStep stuff itself,
 *			set this to 0. setting to 1 make window options work)
 *
 * Callback Attributes
 * MG_RIWINDOWICONIFIED		calls back when window iconifies
 * MG_RIWINDOWDEICONIFIED	calls back when window deiconifies
 * MG_RIWINDOWEXPOSED		if you use a non-retained window, this
 * 				callback will inform you if window exposes
 * MG_RIWINDOWRESIZED		calls back when window resizes
 * MG_RIWINDOWCLOSED		calls back when user closes window via
 * 				title bar close button
 * MG_RIWINDOWBECAMEKEY		calls back when user selects the window as key
 * MG_RIWINDOWBECAMEMAIN	calls back when the window becomes main
 *
 *
 * NOTE: If you're application is not written in the context of the appkit
 * (as is the simple viewer example) then standalone is automatically set
 * to process events in mg_worldend. If you deselect this, no callbacks
 * will be performed because no events leading to the callbacks will be
 * processed, unless your application handles this itself somehow...
 */
 

/* temporary hook for debugging */
extern void mgri_debugcontext();
