#include <stdio.h>
#include "mg.h"
#include "mgP.h"
#include "mgri.h"
#include "transform.h"
#include <ri/ri.h>

typedef struct mgricontext {
  struct mgcontext mgctx;	/* The mgcontext */
  int born;			/* Has window been displayed on the screen? */
  int dying;			/* Is the window being closed from titlebar? */
  int win;			/* window ID, or 0 */
  int standalone;		/* 1 if program ignores appkit, 0 otherwise */
  				/* (determains if events are prcssed by mg) */
  int polymode;			/* method to draw polyhedra via mgri_polylist*/
  int lflushlimit;		/* max polygons per RiPointsPolygon call */
				/* for RI_LINE representation            */
  int fflushlimit;		/* max polygons per RiPointsPolygon call */
  				/* for RI_PRIMITIVE representation 	 */
  int drawsfaces;
  Transform W2C;		/* current W2C xform */
  Transform C2W;		/* current C2W xform */
  Transform W2S;		/* camera-to-screen xform */
  Transform O2S;		/* current object-to-screen xform */
  void (*callback)(struct mgricontext *c, int event);

  Point3 cpos;                  /* current-coordinate position of camera
                                 * (used for software normal flipping)
				 * (and quickrenderman  line nudging */
  int hascpos;                  /* cpos is valid */

    
  /* following are for NeXTs */
  char *nxwindow;		/* this is really an id */
  char *nxview;			/* ditto */
  RtToken qrmContext;		/* the QuickRenderman context */
  RtToken windowresource;	/* each window has it's own context */
  int debug;			/* debug flag to output ri code to ri.rib */
  RtToken debugContext;		/* the context that will send ri to a file */
  RtToken debugResource;	/* resource that will send ri to a file */
  RtInt mgvorigin[2];		/* MGView origin - tells QRMAN where to draw */
  int plni;			/* number of verticees in polyline buffer */
  int plvi;			/* number of polylines in polyline buffer */
  int plbuffsize;		/* size of the polyline buffer */
} mgricontext;

/* These are totally private, should not (yet) be in mgri.h */
enum {
  MGRI_POLYGONS,
  MGRI_POINTSPOLYGONS,
  MGRI_DEVIDEDPOLYLIST
};

#define _mgric		((mgricontext*)_mgc)
extern mgricontext *MGRI;	/* For debugging */

#define RI_X 0
#define RI_Y 1
#define RI_Z 2

#define GVMAXF 600 /* face drawing - vertices per RiPointsPolygons call */
#define GVMAXL 400 /* edge drawing - ditto */

#define SCRATCHSIZE  1024*32
extern RtPoint *ript;		/* points */
extern RtColor *ricolor;	/* rgb color */
extern RtPoint *rinormal;	/* normals */
extern int *rippi;		/* PointsPolygon polygon index array */
extern int rippis;		/* PointsPolygon polygon index array size */
extern int *ripvi;		/* PointsPolygon vertex index array */
extern int ripvis;		/* PointsPolygon vertex index array size */
extern RtPoint *plp;  		/* vertices */
extern RtColor *plc;  		/* colors */
extern int *plvca;        	/* polyline vertex count array */
extern int *plvia;    		/* vertex index array */

/* the renderman<->oogl transform */
extern Transform cam2ri;

/* If you are running NS3.0 (default), uncomment the next line */
#define NS_3_0_SLOW

/* If you are running NS3.1 or higher, comment out the above line and */
/* uncomment this next line. This improves OFF and VECT performance   */
/* but is still somewhat buggy as far as shading goes - performance only */
/* #define NS_3_X_FAST */



/* here we define a simple routines to realloc scratch buffers if necessary */
#define CHECK_VCN(nv,nc,nn)						\
    if(nv>SCRATCHSIZE) {						\
        ript = realloc(ript, nv*sizeof(RtPoint));			\
	if(nc>SCRATCHSIZE) ricolor =					\
		realloc(ricolor, nc*sizeof(RtColor));			\
	if(nn>SCRATCHSIZE) rinormal =					\
		realloc(rinormal, nn*sizeof(RtPoint));			\
    }
#define CHECK_VC(nv,nc)							\
    if(nv>SCRATCHSIZE) {						\
        ript = realloc(ript, nv*sizeof(RtPoint));			\
	if(nc>SCRATCHSIZE) ricolor =					\
		realloc(ricolor, nc*sizeof(RtColor));			\
    }

/* here we define a simple normalization routine for HPt3 -> RtPoint */
/* we use this because it's somewhat faster then Hpt3Normalize       */
#define mgri_normalize(src,rtpoint) 				\
  { register HPoint3 *hpt3 = src;				\
    *(Point3 *)(rtpoint) = *(Point3 *)(hpt3);			\
    if(hpt3->w!=1. && hpt3->w!=0.0) {				\
	rtpoint[RI_X]/=hpt3->w;					\
	rtpoint[RI_Y]/=hpt3->w;					\
	rtpoint[RI_Z]/=hpt3->w;					\
    }								\
   }

//void mgri_normalize(HPoint3 *p, RtPoint r);


void mgri_drawline(HPoint3 *p1, HPoint3 *p2, Color *c);
void mgri_drawpoint(HPoint3 *p);
void mgri_plflush();
void mgri_flushbuffer();
void mgri_processevents();
void mgri_closer();
