/*---------------------------------------------------------------------------*/
/*   TYPEFILE.H                                                              */
/*---------------------------------------------------------------------------*/

#include <stdio.h>
#include <math.h>
#ifdef NeXT
#include <sys/malloc.h>
#else /* any other reasonable UNIX */
#include <malloc.h>
#endif

#define INFINITY HUGE_VAL
/* change HUGE to HUGE_VAL if you are working on the iris */

#define V_IS_INFINITY(z) ((*z)[0] == INFINITY)
#define EPSILON 1e-07

#define COMPRINT(z) (printf ("%.15f + %.15f i\n", z.real, z.imag))
#define VEC3PRINT(v) (printf ("%lf %lf %lf\n", (*v)[0], (*v)[1], (*v)[2]))
#define VEC4PRINT(v) 	\
               (printf ("%lf %lf %lf %lf\n\n",(*v)[0],(*v)[1],(*v)[2],(*v)[3]))

#define CHECK_MEM(ptr) if (! ptr) {printf ("Out of memory.\n"); exit (1);}

#define MODULUS(z) (sqrt (z.real * z.real + z.imag * z.imag))

typedef struct {
    double real, imag;
} complex;


typedef complex lin_frac[2][2];

#ifndef _proj_matrix_
#define _proj_matrix_
typedef double proj_matrix[4][4];
#endif


typedef double vec3[3];
typedef double vec4[4];



/* in complex.c */
extern complex		zero;
extern complex 		plus ();
extern complex		minus ();
extern complex		times ();
extern complex 		div ();
extern complex 		conjugate ();

/* in fourtuple.c */
extern vec4		*svmul4 ();
extern double 		innerproduct3 ();
extern void		mat4print ();
extern void		matmatmul4 ();
extern vec4		*vecmatmul4 ();
extern vec4		*normalize4 ();


/* in hyp3.c */
extern vec4		*conf2proj ();
extern vec4 		*proj2conf ();
extern vec3		*ball2hs ();
extern vec4		*hs2ball ();
extern proj_matrix	*Ta ();
extern vec4		*e_sub_i ();
extern void	sl2c2proj ();


/* in linfrac.c */
extern void		lf_print ();
extern lin_frac		*lf_mult ();
extern lin_frac		*lf_inverse ();
extern vec3		*lfqmul ();
