/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef TRANSFORMNDEF
#define TRANSFORMNDEF

#include "hpointn.h"	/* Defines HPointN and TransformN */
#include "transform.h"

/*
 * Space & model flags; used to specify what space we're in, and
 * a model for hyperbolic space.  The actual value may be a logical
 * OR of a space and a model value.
 */

	/* Construct a transform.  NULL a => identity */
/*skip*/
extern TransformN *TmNCreate( int idim, int odim, HPtNCoord *a);
	/* Destroy */
/*skip*/
extern void TmNDelete( TransformN *T );

	/* Get and set space */
/*skip*/
extern int TmNSpace( const TransformN *T );
/*skip*/
extern TransformN *TmNSetSpace( TransformN *T, int space );

	/* Invert */
extern TransformN *TmNInvert( const TransformN *T, TransformN *Tinv);

	/* Transpose */
extern TransformN *TmNTranspose( const TransformN *from, TransformN *to);

	/* Multiply transforms */
extern TransformN *TmNConcat( const TransformN *A, const TransformN *B, TransformN *result);

	/* Copy */
extern TransformN *TmNCopy( const TransformN *Tsrc, TransformN *Tdst);

	/* Set to identity */
extern TransformN *TmNIdentity( TransformN *T);

	/* Euclidean translations */
extern TransformN *TmNTranslate( TransformN *T, const HPointN *p);
extern TransformN *TmNTranslateOrigin( TransformN *T, const HPointN *pt);

	/* Translations by the space of 'pt' */
/*skip*/
extern TransformN *TmNSpaceTranslate( TransformN *T, HPointN *pt);
/*skip*/
extern TransformN *TmNSpaceTranslateOrigin( TransformN *T, HPointN *pt);

	/* Scale by the components of 'amount' */
extern TransformN *TmNScale( TransformN *T, const HPointN *amount);

	/* Construct a geodesic rotation taking vector 'from' to 'toward' */
extern TransformN *TmNRotate( TransformN *T, const HPointN *from, const HPointN *toward);

	/* Modify nxn matrix to accomodate usual matrix from Geomview */
/*skip*/
extern TransformN *TmNApplyDN( TransformN *T, int *permute, Transform3 delta);

	/* Add ones and zeros to a matrix to make it larger */
extern TransformN *TmNPad(TransformN *T1, short idim, short odim, TransformN *T2);

	/* Add just zeros to a matrix to make it larger */
extern TransformN *TmNPadZero(TransformN *T1, short idim, short odim, TransformN *T2);

	/* Return dimensions of a TransformN.  Value is first dimension. */
	/* idim and/or odim may be NULL, in which case they're not returned */
extern int TmNGetSize(const TransformN *T, int *idim, int *odim);

	/* Print a TransformN */
extern void TmNPrint(FILE *f, const TransformN *T);

	/* Get a TransformN, given a file pointer */
extern TransformN *TmNRead(FILE *f);

	/* scale all elements of "upper left" of matrix by a scalar */
extern TransformN *CtmNScale( HPtNCoord s, TransformN *in, TransformN *out);

# endif
