#define poly ___poly
extern "C" {
#include <stdlib.h>
#include "forms.h"
#include "4dmapfd.h"
}
#undef  poly
#include "4dmap.h"

#define X 0
#define Y 1
#define Z 2
#define W 3

static FL_OBJECT **axes[4] = { &XInput, &YInput, &ZInput, &WInput };

// ===========================================================================
// Internals of objects:

object4d::object4d()
{
}

object4d::~object4d()
{
}

object3d::object3d()
{
}

object3d::~object3d()
{
}


int object4d::read4dfile(char *name)
{
 filename = new char[256];
 int readworked;

 readworked = load_off_file(&polyhedron,&polyvertex,name,filename);
 if (!readworked) return(0);
 polyvertex.clip_vertex(1.0,1.0,1.0,1.0,100000.0,0); /*Doesn't clip anything*/
 polyhedron.clip_polys(&polyvertex);
 polyvertex.refresh_vertex_list();
 polyhedron.refresh_poly_list();
 delete filename;
 return (1);
}

object4d *object4d::copyobj()
{
 object4d *a=NULL;
 return a;
}

int object4d::clipobj(clip_plane *clipper, int *obj_loaded)
{
 polyvertex.clip_vertex(clipper->ax,clipper->by,clipper->cz,clipper->dw,
			clipper->depth,0);
 polyhedron.clip_polys(&polyvertex);
 polyvertex.refresh_vertex_list();
 polyhedron.refresh_poly_list();
 if (polyvertex.numvtx<2) {*obj_loaded = 0;}
 return (1);
}

transform::transform()
{
  return;
}

void transform::pipe3dout(FILE *fout, object4d *in, float T[4][4], clip_plane *clipper)
{
  fprintf(fout,"(geometry 4dthing {\n");
  fprintf(fout,"COFF\n %d %d 1\n",in->polyvertex.numvtx,in->polyhedron.numpoly);
  in->polyvertex.write_vertices3d(fout,T,clipper);
  in->polyhedron.write_polys(fout);
  fprintf(fout,"})\n");
  fflush(fout);
}

void transform::setproj(object4d *in, int proj)
{
 in->polyvertex.setproj(proj);
}

void transform::fileout(char *filename, object4d *in)
{
 FILE *savefile;

 if (!(savefile=fopen(filename,"w")))
 {
  //fl_addto_browser(Browser, "Couldn\'t save file.");
  return;
 }
 fprintf(savefile,"4OFF\n");
 fprintf(savefile,"%d %d 1\n",in->polyvertex.numvtx,in->polyhedron.numpoly);
 in->polyvertex.write_vertices(savefile);
 in->polyhedron.write_polys(savefile);
 fclose(savefile);
}

void transform::copy(object4d *out, object4d *in)
{
 out = in->copyobj();
}

main()
{

// ===========================================================================
//
// Variables for the main loop...
//
//

  float slice_depth; // Var containing depth of slice for clipping
  float T[4][4];     // Transformation Matrix
  float TS[4][4];    // Slice Matrix
  float upbnd,lowbnd;

  FL_OBJECT *retobj; // Object pointer used for polling forms
  int i,j;           // indices for the transformation matrix
  char str[255];     // String from input box
  char fnm[255];     // File name
  int file_load=0;
  int obj_loaded=0;
  FILE *pipeout;

// End of variables
// ===========================================================================
// Forms initialization

  foreground();      // Make debugging easier
  fl_init();	     // Initialize forms
  create_the_forms();// Create forms

  fl_set_slider_bounds(SliceSlider, 0.0, 10.0);
  fl_set_slider_value(SliceSlider, 0.0);
  fl_set_slider_return(SliceSlider, TRUE);
  fl_set_button(PerspButton, 1);
  fl_set_button(ColorSchemeButton, 0);

  fl_show_form(MainPanel,
	FL_PLACE_SIZE/*interactive placement*/,
	TRUE/*border*/,
	"4D-Viewer");

// End of Forms initialization
// ===========================================================================
// Object initialization

   object4d original;
   clip_plane clipper;
   transform ttool;

   original.polyvertex.colorscheme = 0;

   ttool.setproj(&original,1);
   /*if (!(pipeout=fopen("mypipe","w")))
   {
	err_msg("Couldn\'t open pipe.\n");
	exit(0);
   }*/
    pipeout = stdout;

    for (i=0;i<4;i++) {for(j=0;j<4;j++) {T[i][j] = 0.0;} T[i][i] = 1.0;}
    for(i=0; i<4; i++) {
	sprintf(str,"%7.3f %7.3f %7.3f %7.3f",T[0][i],T[1][i],T[2][i],T[3][i]);
	fl_set_input(*axes[i],str);
    }
    fl_set_fouraxis_basis(ProjAxis, (float *)T);
    fl_set_fouraxis_basis(SliceAxis, (float *)T);
    fl_get_fouraxis_basis(SliceAxis, (float *)TS);
    clipper.ax = TS[3][0];
    clipper.by = TS[3][1];
    clipper.cz = TS[3][2];
    clipper.dw = TS[3][3];
    slice_depth = fl_get_slider_value(SliceSlider);
    clipper.depth = (double)slice_depth;
	sprintf(str,"%f",TS[3][0]);
	fl_set_input(AInput,str);
	sprintf(str,"%f",TS[3][1]);
	fl_set_input(BInput,str);
	sprintf(str,"%f",TS[3][2]);
	fl_set_input(CInput,str);
	sprintf(str,"%f",TS[3][3]);
	fl_set_input(DInput,str);
	sprintf(str,"%f",clipper.depth);
	fl_set_input(EInput,str);

// End of object initialization
// ===========================================================================


// The do loop from hell!!!

  do
  {
    /*if (fl_get_button(ProjTieButton))
    {
     fl_get_fouraxis_basis(ProjAxis, (float *)T);
     for(i=0; i<4; i++) {
	sprintf(str,"%7.3f %7.3f %7.3f %7.3f",T[0][i],T[1][i],T[2][i],T[3][i]);
	fl_set_input(*axes[i],str);
     }
    }*/

    retobj = fl_do_forms();

    if (retobj==ShowProj)
    {
     fl_show_form(ProjectionPanel,
	FL_PLACE_SIZE/*interactive placement*/,
	TRUE/*border*/,
	"Projection");
    }
    else
    if (retobj==ShowSlice)
    {
     fl_show_form(SlicePanel,
	FL_PLACE_SIZE,
	TRUE,
	"Slicing");
    }
    else 
    if (retobj==SliceFlip)
    {
     clipper.ax*=(-1.0);
     clipper.by*=(-1.0);
     clipper.cz*=(-1.0);
     clipper.dw*=(-1.0);
     clipper.depth*=(-1.0);
     slice_depth = clipper.depth;
     sprintf(str,"%f",clipper.depth);
     fl_set_input(EInput,str);
     if (obj_loaded) ttool.pipe3dout(pipeout,&original,T,&clipper);
    }
    else
    if (retobj==ProjCloseButton)
      fl_hide_form(ProjectionPanel);
    else
    if (retobj==SliceCloseButton)
      fl_hide_form(SlicePanel);
    else
    if (retobj==DefaultProj)
    {
     for (i=0;i<4;i++) {for(j=0;j<4;j++) {T[i][j] = 0.0;} T[i][i] = 1.0;}
     for (i=0;i<4;i++)
     {
      sprintf(str,"%7.3f %7.3f %7.3f %7.3f",T[0][i],T[1][i],T[2][i],T[3][i]);
      fl_set_input(*axes[i],str);
     }
     fl_set_fouraxis_basis(ProjAxis, (float *)T);
     if (obj_loaded) ttool.pipe3dout(pipeout,&original,T,&clipper);

    }
    else
    if (retobj==ProjAxis)
    {
	if (1/*fl_get_button(ProjTieButton)*/)
	{
	 fl_get_fouraxis_basis(ProjAxis, (float *)T);
         for(i=0; i<4; i++) {
	  sprintf(str,"%7.3f %7.3f %7.3f %7.3f",T[0][i],T[1][i],T[2][i],T[3][i]);
	  fl_set_input(*axes[i],str);
	 }
	 if (obj_loaded) ttool.pipe3dout(pipeout,&original,T,&clipper);
	}
    }
    else
    if ((retobj==SliceAxis)||(retobj==AInput)||(retobj==BInput)||
	(retobj==CInput)||(retobj==DInput))
    {
	if (retobj==SliceAxis)/*fl_get_button(SliceTieButton))*/
	{
	 fl_get_fouraxis_basis(SliceAxis, (float *)TS);
	}
	else
	{
	 TS[3][0]=0.0;TS[3][1]=0.0;TS[3][2]=0.0;TS[3][3]=0.0;
	 sscanf(fl_get_input(AInput), "%f", &TS[3][0]);
	 sscanf(fl_get_input(BInput), "%f", &TS[3][1]);
	 sscanf(fl_get_input(CInput), "%f", &TS[3][2]);
	 sscanf(fl_get_input(DInput), "%f", &TS[3][3]);
	}
	clipper.ax = TS[3][0];
	clipper.by = TS[3][1];
	clipper.cz = TS[3][2];
	clipper.dw = TS[3][3];
	sprintf(str,"%f",TS[3][0]);
	fl_set_input(AInput,str);
	sprintf(str,"%f",TS[3][1]);
	fl_set_input(BInput,str);
	sprintf(str,"%f",TS[3][2]);
	fl_set_input(CInput,str);
	sprintf(str,"%f",TS[3][3]);
	fl_set_input(DInput,str);
	if (obj_loaded) ttool.pipe3dout(pipeout,&original,T,&clipper);
    }
    else
    if (retobj==ExtraButton)
    {
     fl_show_form(ExtraPanel,
	FL_PLACE_SIZE/*interactive placement*/,
	TRUE/*border*/,
	"Features");
    }
    else
    if (retobj==OrthoButton)
    {
     ttool.setproj(&original,0);
     if (obj_loaded) ttool.pipe3dout(pipeout,&original,T,&clipper);
    }
    else
    if (retobj==PerspButton)
    {
     ttool.setproj(&original,1);
     if (obj_loaded) ttool.pipe3dout(pipeout,&original,T,&clipper);
    }
    else
    if (retobj==ColorSchemeButton)
    {
      original.polyvertex.colorscheme = fl_get_button(retobj);
     if (obj_loaded) ttool.pipe3dout(pipeout,&original,T,&clipper);
    }
    else
    if (retobj==ExtraCloseButton)
    {
      fl_hide_form(ExtraPanel);
    }
    else
    if (retobj==FileInput)
    {
	//fl_get_input(FileInput));
    }
    else 
    if (retobj==SliceSlider)
    {
	slice_depth = fl_get_slider_value(SliceSlider);
        sprintf(str,"%f",slice_depth);
	clipper.depth = (double)slice_depth;
	fl_set_input(EInput,str);
	if (obj_loaded) ttool.pipe3dout(pipeout,&original,T,&clipper);
    }
    else
    if (retobj==EInput)
    {
	sscanf(fl_get_input(retobj), "%f",&slice_depth);
        //printf("Slice Value: %f\n",slice_depth);
	clipper.depth = (double)slice_depth;
	fl_set_slider_value(SliceSlider, (float) slice_depth);
	if (obj_loaded) ttool.pipe3dout(pipeout,&original,T,&clipper);
    }
    else
    if (retobj==SliceButton)
    {
        if (obj_loaded)
	{
	 if (original.clipobj(&clipper,&obj_loaded));
           //printf("Slice the object\n");
	 if (obj_loaded)
	  ttool.pipe3dout(pipeout,&original,T,&clipper);
	 else
	 {
	   fprintf(pipeout,"(delete 4dthing)\n");
	   fflush(pipeout);
	 }
	}
    }
    else
    /*if (retobj==UndoSliceButton)
    {
	if (file_load)
	 if (original.read4dfile(fnm))
	 {
	   sliderval(&lowbnd,&upbnd);
	   fl_set_slider_bounds(SliceSlider,lowbnd,upbnd);
	   obj_loaded=1;
	   ttool.pipe3dout(pipeout,&original,T,&clipper);
	 }
    }*/
    if (retobj==LoadFile)
    {
        //printf("Loading file...\n");
	if (!(original.read4dfile(fl_get_input(FileInput))))
        {
	  fprintf(stderr,"Couldn\'t read file.\n");
	   //fl_addto_browser(Browser,"Couldn\'t read file.");
        }
	else
	{
	   strcpy(fnm,fl_get_input(FileInput));
	   sliderval(&lowbnd,&upbnd);
	   fl_set_slider_bounds(SliceSlider,lowbnd,upbnd);
           fl_set_slider_value(SliceSlider, upbnd);
           slice_depth = upbnd;
           clipper.depth = (double)slice_depth;
	   sprintf(str,"%f",clipper.depth);
	   fl_set_input(EInput,str);
           clipper.depth = (double)slice_depth;
	   //printf("Bounds set: %f %f\n",lowbnd,upbnd);
	   obj_loaded=1;
	   file_load=1;
	   ttool.pipe3dout(pipeout,&original,T,&clipper);
	}
    }
    else
    if (retobj==StoreFile)
    {
	if (obj_loaded)
	 ttool.fileout(fl_get_input(FileInput),&original);
    }
    else
    {
	for(i=0; i<4; i++) {
	  if(retobj == *axes[i]) {
	    /* Text input value changed: change fouraxis accordingly */
	    sscanf(fl_get_input(retobj), "%f %f %f %f",
			    &T[0][i],&T[1][i],&T[2][i],&T[3][i]);
	         sprintf(str,"%7.3f %7.3f %7.3f %7.3f",T[0][i],T[1][i],T[2][i],T[3][i]);
		 fl_set_input(*axes[i],str);
	         if (obj_loaded) ttool.pipe3dout(pipeout,&original,T,&clipper);
		}
	  }
    }
  } while (retobj != ExitButton);
}
