#include <math.h>
extern "C" {
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
}

class clip_plane
{
 public:
 clip_plane();
 double ax,by,cz,dw,e,depth;
};

class vertex
{
 public:
 vertex();
 void read_vertex4d(int, FILE *, int);
 void read_vertex(int, FILE *, int);
 vertex *next;
 double x,y,z,w;
 double r,g,b,a;
 int clip;
 int num;
};

class vertex_list
{
 public:
 vertex_list();
 void read_vertices(int, FILE *);
 void write_vertices(FILE *);
 void write_vertices3d(FILE *, float [4][4], clip_plane *);
 void setproj(int);
 void clip_vertex(double, double, double, double, double, int);
 void put_in_array(vertex **);
 vertex *add_vertex(double, double, double, double);
 void refresh_vertex_list();
 int numvtx;
 double a,b,c,d,e;
 int side;
 int vtype;
 int colorscheme;
 int coloron;

 private:
 vertex *head;
 vertex *point;
 int projection;
};

class pvtx
{
 public:
 pvtx();
 void read_pvtx(FILE *);
 int num;
 vertex *me;
 pvtx *next;
};

class polyvtx_list
{
 public:
 polyvtx_list();
 void read_polyvtx(int, FILE *);
 void write_polyvtx(FILE *);
 int find_unclipped_vertex(vertex **);
 int clip_each_vertex(vertex_list *, vertex **);
 int numvtx;

 private:
 pvtx *head;
 pvtx *point;
};

 
class poly
{
 public:
 poly();
 void read_poly(FILE *);
 void clip_poly(vertex_list * cli, vertex **);
 int numvtx;
 int clipped;
 polyvtx_list *me;
 poly *next;
};

class poly_list
{
 public:
 poly_list();
 void read_polys(int, FILE *);
 void write_polys(FILE *);
 void clip_polys(vertex_list *);
 void refresh_poly_list();
 int numpoly;

 private:
 poly *head;
 poly *point;
};

int load_off_file(poly_list *, vertex_list *, char *, char *);
void err_msg(char *);
void sliderval(float *, float *);
