#include <stdio.h>
#include <stdlib.h>
#include <string.h>

extern "C" {
int sginap(long);
#include <forms.h>
#include "anim.h"
#include "glob.h"
}
#include "animate.h"


void showusage()
{
 fprintf(stderr,"Incorrect command line arguments.\n");
 fprintf(stderr,"Usage: animate [-w posx posy] [-p] [-b] [-s speed] [-o] [-S script] [-hide]\n\t\t[-f file1 file2 ...]\n");
 exit(0);
}

script::script()
{
 maxline = 0;
 linenum = 0;
 looping = 0;
 bouncing = 0;
 playing = 0;
 speed = 0;
 slow = 0;
 direct = 1;
 topline = 1;
 my_browser = NULL;
 loaded=0;
 gonce=0;
 commnd[0]='\0';
}

void script::once()
{
 gonce = !gonce;
}

script::~script()
{
 // do nothing;
}

void script::init(int numlines, FL_OBJECT *brow)
{
 if (!numlines) return;
 my_browser = brow;
 maxline = numlines;
 playing = 0;
 if (!loaded)
 {
  fprintf(stdout,"(geometry animate : anim)\n");
  fflush(stdout);
 }
 loaded = 1;
 linenum = 0;
}

void script::start_playing()
{
 playing = 1;
}

void script::stop_playing()
{
 playing = 0;
}

void script::toggle_looping()
{
 looping = !looping;
}

void script::change_speed(int spd)
{
  speed = spd;
}

void script::set_linenum(int lne)
{
  char *ln;

  fl_freeze_object(my_browser);
  if (linenum)
  {
   ln = fl_get_browser_line(my_browser, linenum);
   if (ln[0]=='@')
    fl_replace_browser_line(my_browser, linenum, &(ln[3]));
  }
  linenum = lne;
  ln = fl_get_browser_line(my_browser, linenum);
  sprintf(line,"@C1%s",ln);
  fl_replace_browser_line(my_browser, linenum, line);
  fl_unfreeze_object(my_browser);
  show_geom(linenum);
}

void script::change_direction(int dir)
{
 if ((dir==1)||(dir==(-1)))
  direct = dir;
 else
 {
  if (direct==1)
   direct = -1;
  else
   direct = 1;
 }
}

void script::toggle_bounce()
{
 bouncing = !bouncing;
}

void script::do_step()
{
 char *ln;
 int   old;
 int   nline;

 if (!maxline) return;
 fl_freeze_object(my_browser);
 if ((!looping)&&(!bouncing))
 {
 if (gonce&&(((linenum==1)&&(direct==(-1)))||((linenum==maxline)&&(direct==1))))
  {
   stop_playing();
  }
  else {
  if (linenum)
  {
   ln = fl_get_browser_line(my_browser, linenum);
   if (ln[0]=='@')
    fl_replace_browser_line(my_browser, linenum, &(ln[3]));
  }
  linenum+=direct;
  if (linenum<1) linenum = maxline;
  if (linenum>maxline) linenum = 1;
  ln = fl_get_browser_line(my_browser, linenum);
  sprintf(line,"@C1%s",ln);
  fl_replace_browser_line(my_browser, linenum, line);
  show_geom(linenum);
  }
 }
 else
 if ((!looping)&&(bouncing))
 {
 if (gonce&&(((linenum==1)&&(direct==(-1)))||((linenum==maxline)&&(direct==1))))
  {
   stop_playing();
  }
  else {
  if (linenum)
  {
   ln = fl_get_browser_line(my_browser, linenum);
   if (ln[0]=='@')
    fl_replace_browser_line(my_browser, linenum, &(ln[3]));
  }
  linenum+=direct;
  if (linenum<1)
  {
   linenum = 2;
   direct = 1;
  }
  if (linenum>maxline)
  {
   linenum = maxline-1;
   direct = -1;
  }
  if (maxline==1) linenum = 1;
  ln = fl_get_browser_line(my_browser, linenum);
  sprintf(line,"@C1%s",ln);
  fl_replace_browser_line(my_browser, linenum, line);
  show_geom(linenum);
 }
 }
 else
 if ((looping)&&(!bouncing))
 {
  old = linenum;
  linenum+=direct;
  if (gonce&&((linenum<1)||(linenum>maxline)))
  {
   stop_playing();
   linenum = old;
  }
  else
  {
   if (linenum<1) linenum = maxline;
   if (linenum>maxline) linenum = 1;
   while ((!fl_isselected_browser_line(my_browser,linenum))&&(linenum!=old)&&playing)
   {
    linenum+=direct;
    if (gonce&&((linenum<1)||(linenum>maxline)))
    {
     stop_playing();
     linenum=old;
    }
    if (playing)
    {
     if (linenum<1) linenum = maxline;
     if (linenum>maxline) linenum = 1;
    }
   }
   nline=linenum;
   linenum=old;
   set_linenum(nline);
  }
 }
 else
 if (looping&&bouncing)
 {
  old = linenum;
  linenum+=direct;
  if (gonce&&((linenum<1)||(linenum>maxline)))
  {
   stop_playing();
   linenum = old;
  }
  if (linenum<1) {linenum = 1;change_direction(0);}
  if (linenum>maxline) {linenum = maxline;change_direction(0);}
  while ((!fl_isselected_browser_line(my_browser,linenum))&&(linenum!=old))
  {
   linenum+=direct;
   if (gonce&&((linenum<1)||(linenum>maxline)))
   {
    stop_playing();
    linenum=old;
   }
   if (playing)
   {
    if (linenum<1) {linenum = 1;change_direction(0);}
    if (linenum>maxline) {linenum = maxline;change_direction(0);}
   }
  }
  nline=linenum;
  linenum=old;
  set_linenum(nline);
 }
 if ((linenum<topline)||(linenum>(topline+6)))
 {
  topline+=direct;
  if ((linenum<topline)||(linenum>(topline+6)))
   topline = linenum;
  fl_set_browser_topline(my_browser,topline);
 }
 fl_unfreeze_object(my_browser);
}

void script::add_command(char *incoming)
{
 strcpy(commnd,incoming);
}

void script::animate()
{
 if (speed==1000)
  return;
 if (playing)
 {
  sginap((long)speed/50);
  slow+=50;
  if (slow>speed)
  {
   slow=0;
   do_step();
  }
 }
}

void script::clean()
{
 int i;

 if (loaded)
 for (i=1;i<(maxline+1);i++)
 {
  fprintf(stdout,"(read geometry { define a%d { LIST } } )\n",i);
  fflush(stdout);
 }
}

void script::show_geom(int linenum)
{
 char c = ' ';

 fprintf(stdout,"(echo x)\n");
 fprintf(stdout,"(read geometry { define anim { LIST : a%d } } )\n",linenum);
 if (commnd[0]!='\0')
   fprintf(stdout,commnd,linenum);
 fflush(stdout);
 while ((c!='x')&&(!feof(stdin)))
 {
  c = (char) fgetc(stdin);
 }
}

void err_msg(char *msg)
{
 fprintf(stderr,"%s\n",msg);
}

void get_file(FL_OBJECT *browse, char *filename, int *maxlines)
{
 FILE *thisfile;
 char line[256],ch=' ';
 char tmpline[257];
 int  chnum=0,spc=1,pos=0;

 (*maxlines) = 0;
 fl_clear_browser(browse);
 if (!(thisfile=fopen(filename,"r")))
 {
  err_msg("Couldn\'t open file.");
  return;
 }
 fl_freeze_object(browse);
 while (!feof(thisfile))
 {
  spc=1;chnum=0;pos=0;ch=' ';
  while ((chnum<256)&&(ch!='\n')&&(!feof(thisfile)))
  {
   line[chnum] = ch = (char) fgetc(thisfile);
   chnum++;
   if (ch=='#')
   {
    while ((!feof(thisfile))&&(ch!='\n'))
    {
     ch = (char) fgetc(thisfile);
    }
    ch = '\n';
   }
   if ((ch!=' ')&&(ch!='\t')&&(ch!='\n')&&spc)
   {
    spc=0;
    pos=chnum-1;
   }
  }
  if (!spc)
  {
   line[chnum-1] = '\0';
   chnum=pos;
   while((line[pos]!=' ')&&(line[pos]!='\t')&&(line[pos]!='\0'))
    pos++;
   line[pos]='\0';
   if (pos!=chnum)
    {
     fprintf(stdout,"(read geometry { define a%d < \"%s\" } )\n",
     (*maxlines)+1,&(line[chnum]));
     fflush(stdout);
     sprintf(tmpline," %s",&(line[chnum]));
     fl_add_browser_line(browse,tmpline);
     (*maxlines)++;
    }
  }
 }
 fl_unfreeze_object(browse);
 fclose(thisfile);
}

void read_glob(FL_OBJECT *browse, char **gfiles, int *maxlines)
{
 int  fnum=0;
 char tmpline[256];
 char ret;
 FL_OBJECT *retobj;

 fl_clear_browser(browse);
 while ((gfiles[fnum]!=NULL)&&((*gfiles[fnum])!='\0'))
 {
  fprintf(stdout,"(read geometry { define a%d < \"%s\" } )\n",
	  fnum+1,gfiles[fnum]);
  fprintf(stdout,"(read geometry { define anim { LIST : a%d } } )\n",fnum+1);
  fprintf(stdout,"(echo q)");
  fflush(stdout);
  fscanf(stdin,"%c",&ret);
  if (ret!='q')
   return;
  retobj = fl_check_forms();
  if (retobj==ExitButton)
   exit(0);
  sprintf(tmpline," %s",gfiles[fnum]);
  fl_add_browser_line(browse,tmpline);
  fnum++;
 }
 (*maxlines) = fnum;
}


void set_info(FL_OBJECT *myinfo)
{
 int i;
 static char *inf[] = {
 "By Daeron Meyer",
 "Copyright (c) 1992",
 "The Geometry Center",
 "anonymous ftp: geom.umn.edu",
 "email: software@geom.umn.edu",
 " ",
 "Geom-Animator is free software and is",
 "designed to be used as an animation tool",
 "for Geomview. It provides several simple",
 "animation controls such as looping, bouncing,",
 "and single frame stepping. A brief description",
 "of functionality is included but for a more",
 "complete tutorial, read the man pages.",
 " ",
 "To read in a list of frames, enter their names",
 "in the input box at the bottom of the main panel",
 "and press return or click on Load. To read in a",
 "script containing a list of frames type the name",
 "of the script in the input box and click on the",
 "Script button.",
 " ",
 "Once the frames have been read in (the",
 "animate object will appear in the geomview",
 "object browser) one can scroll through the",
 "frames by clicking on play or clicking on the",
 "forward or backward step buttons. Clicking on",
 "stop will cause animator to stop playing frames.",
 " ",
 "The speed at which frames are playing can be",
 "adjusted using the speed slider. Playing slowly",
 "through the frames can also be accomplished",
 "by holding one of the step buttons down.",
 " ",
 "Clicking on the once button will make animator",
 "go through a sequence of frames once, and",
 "then cause it to stop on the last or first frame.",
 " ",
 "Toggling the bounce button on will put animator",
 "in bounce mode. This means that once the last",
 "or first frame is reached (while playing frames)",
 "the direction of play will be automatically",
 "reversed.",
 " ",
 "Toggling the loop button on will put animator",
 "in loop mode. In this mode, animator confines",
 "itself to looping through only the frames that",
 "have been outlined in the frame browser."
 };
 for (i=0;i<47;i++)
  fl_add_browser_line(myinfo, inf[i]);
}
 


//------------------------------------------------------

main(int argc, char *argv[])
{
 int	    maxlines=0;
 int	    line=0;
 int	    hidden=0;
 FL_OBJECT *retobj=NULL;
 script     myscript;
 char     **fils;
 int	    fnum,tmp,filesin = 0,scriptin = 0,playin=0;
 int	    block=1;
 int	    argnum=1;
 int	    wposx = -1, wposy = -1;

 foreground();
 fl_init();
 create_the_forms(); // create the forms
 fl_set_slider_bounds(SpeedSlide,0,1000);
 fl_set_slider_value(SpeedSlide,1000);

 set_info(InfoBrowse);

 if (argc>1)
  while (argnum<argc)
  {
    if (*argv[argnum] == '-')
    {
      if (!strcmp(argv[argnum],"-w"))
      {
	if ((argc-argnum)<3) showusage();
        if (!sscanf(argv[argnum+1],"%d",&wposx) ||
	    !sscanf(argv[argnum+2],"%d",&wposy)) showusage();
	argnum+=3;
      }
      else
      if (!strcmp(argv[argnum],"-p"))
      {
	playin = 1;
    	block=0;
	argnum++;
      }
      else
      if (!strcmp(argv[argnum],"-b"))
      {
	myscript.toggle_bounce();
	fl_set_button(BounceButton, 1);
	argnum++;
      }
      else
      if (!strcmp(argv[argnum],"-s"))
      {
	if ((argc-argnum)<2) showusage();
	if (!sscanf(argv[argnum+1],"%d",&tmp)) showusage();

	tmp *= 10;
	if (tmp<0) tmp = 0;
	if (tmp>1000) tmp = 1000;
	fl_set_slider_value(SpeedSlide,tmp);
	myscript.change_speed(1000-tmp);
	argnum+=2;
      }
      else
      if (!strcmp(argv[argnum],"-hide"))
      {
	hidden = 1;
	argnum++;
      }
      else
      if (!strcmp(argv[argnum],"-o"))
      {
	myscript.once();
	fl_set_button(OnceButton, 1);
	argnum++;
      }
      else
      if (!strcmp(argv[argnum],"-f"))
      {
	if ((argc-argnum)<2) showusage();
	fils = &(argv[argnum+1]);
	argnum = argc;
	filesin = 1;
      }
      else
      if (!strcmp(argv[argnum],"-S"))
      {
	if ((argc-argnum)<2) showusage();
        fprintf(stdout,"(read geometry { define anim { LIST } } )\n");
        fprintf(stdout,"(geometry animate : anim)\n");
        fflush(stdout);
        myscript.clean();
        get_file(ScriptBrowser,argv[argnum+1],&maxlines);
        myscript.init(maxlines,ScriptBrowser);
	argnum+=2;
	scriptin=1;
      }
      else
	showusage();
    }
    else
     showusage();
  }
 if (!hidden)
 {
  if ((wposx<0)||(wposy<0))
  {
    minsize(290,330);
    fl_show_form(Animate, FL_PLACE_FREE, TRUE, "Animate");
  }
  else
  {
    fl_set_form_position(Animate,wposx,wposy);
    fl_show_form(Animate, FL_PLACE_POSITION, TRUE, "Animate");
  }
 }


 if (filesin & !scriptin)
 {
  if (fils!=NULL)
  {
   if (fils[0]!=NULL)
   {
    fprintf(stdout,"(read geometry { define anim { LIST } } )\n");
    fprintf(stdout,"(geometry animate : anim)\n");
    fflush(stdout);
    myscript.clean();
    read_glob(ScriptBrowser,fils,&maxlines);
    myscript.init(maxlines,ScriptBrowser);
   }
  }
 }

 if (playin)
   myscript.start_playing();

 while (retobj!=ExitButton)
 {
  if (block)
   retobj = fl_do_forms();
  else
   retobj = fl_check_forms();
  if (retobj!=NULL)
  {
   if (retobj==InfoButton)
   {
    fl_show_form(InfoPanel, FL_PLACE_SIZE, TRUE, "Info");
   }
   else
   if (retobj==CommandButton)
   {
    fl_show_form(Command, FL_PLACE_SIZE, TRUE, "Command");
   }
   else
   if (retobj==CommandInput)
   {
    fl_hide_form(Command);
    myscript.add_command(fl_get_input(CommandInput));
   }
   else
   if (retobj==CloseButton)
   {
    fl_hide_form(InfoPanel);
   }
   else
   if (retobj==ExitButton)
   {
    exit(0);
   }
   if (retobj == PlayButton)
   {
    myscript.start_playing();
    block=0;
   }
   else
   if (retobj == StopButton)
   {
    myscript.stop_playing();
    block=1;
   }
   else
   if (retobj == LoopButton)
   {
    myscript.toggle_looping();
   }
   else
   if (retobj == StepBButton)
   {
    if (fl_get_button(BounceButton))
    {
     myscript.toggle_bounce();
     fl_set_button(BounceButton,0);
    }
    myscript.stop_playing();
    myscript.change_direction(-1);
    myscript.do_step();
    block=1;
   }
   else
   if (retobj == StepFButton)
   {
    if (fl_get_button(BounceButton))
    {
     myscript.toggle_bounce();
     fl_set_button(BounceButton,0);
    }
    myscript.stop_playing();
    myscript.change_direction(1);
    myscript.do_step();
    block=1;
   }
   else
   /*
   if (retobj == SwitchButton)
   {
    myscript.change_direction(0);
   }*/
   if (retobj == OnceButton)
   {
    myscript.once();
   }
   else
   if (retobj == SpeedSlide)
   {
    myscript.change_speed(1000-(int)fl_get_slider_value(retobj));
   }
   else
   if (retobj == BounceButton)
   {
    myscript.toggle_bounce();
   }
   else
   if (retobj == ScriptBrowser)
   {
    line = fl_get_browser(ScriptBrowser);
    if (line<0)
     line = -line;
    myscript.set_linenum(line);
   }
   else
   if (retobj == ScriptButton)
   {
    fprintf(stdout,"(read geometry { define anim { LIST } } )\n");
    fprintf(stdout,"(geometry animate : anim)\n");
    fflush(stdout);
    myscript.clean();
    get_file(ScriptBrowser,fl_get_input(InputBox),&maxlines);
    myscript.init(maxlines,ScriptBrowser);
   }
   else
   if ((retobj == LoadButton)||(retobj == InputBox))
   {
    fnum=0;
    fils=glob(fl_get_input(InputBox));
    if (fils!=NULL)
    {
     if (fils[0]!=NULL)
     {
      fprintf(stdout,"(read geometry { define anim { LIST } } )\n");
      fprintf(stdout,"(geometry animate : anim)\n");
      fflush(stdout);
      myscript.clean();
      read_glob(ScriptBrowser,fils,&maxlines);
      myscript.init(maxlines,ScriptBrowser);
     }
     free(fils);
    }
   }
  }
  myscript.animate();
 }
}
