#include <stdio.h>
#include <math.h>
#include "geom.h"
#include "mibload.h"
#include "clipboard.mib"
#include "clip.h"

void cut_callback(Widget , XtPointer,
	XmPushButtonCallbackStruct *);
void copy_callback(Widget , XtPointer,
	XmPushButtonCallbackStruct *);
void paste_callback(Widget , XtPointer,
	XmPushButtonCallbackStruct *);
void delete_callback(Widget , XtPointer,
	XmPushButtonCallbackStruct *);


char  obj_name[1000];
Geom *theObject;
int   clipfull;

main(int argc, char **argv)
{
  XtAppContext	App;
  Widget	TopLevel,
		MainWindow,
		CutButton,
		CopyButton,
		PasteButton,
		DeleteButton,
		DrawArea;

  int		no_mi;

  mib_Widget   *MainForm;
  static String	fallbacks[] = {
	"myprog*Foreground:			gray20", /*15*/
	"myprog*Background:			gray70", /*80*/
	"myprog*XmTextField.background:	       DeepSkyBlue",
	"myprog*fontList:\
	-adobe-helvetica-medium-r-normal--14-100-100-100-p-76-iso8859-1",
	NULL};

  no_mi = 0;				/* no motif interface if no_mi = 1 */

  clipfull = 0;
  obj_name[0] = '\0';


  /* initialize application top level widget */

  TopLevel = XtVaAppInitialize(&App, "myprog", NULL, 0,
	&argc, argv, fallbacks, NULL);


  /* configure resize policy of window */

  XtVaSetValues(TopLevel, XmNminWidth, 272, XmNminHeight, 172, NULL);

  /* create the application main window widget */

  MainWindow = XtCreateManagedWidget("MainWindow",
	xmMainWindowWidgetClass, TopLevel, NULL, 0);


  /* load the interface via the mib library */

  MainForm = mib_load_interface(MainWindow,
	Root, MI_FROMSTRING);
/*  MainForm = mib_load_interface(MainWindow, "mib/clipboard.mib", MI_FROMFILE);
*/

  if (MainForm == NULL)
    exit(0);

  /* Set widget pointers to null before trying to find their instances */

  CutButton  = NULL;
  CopyButton  = NULL;
  PasteButton  = NULL;
  DeleteButton  = NULL;
  DrawArea = NULL;

  /* Do similarly when trying to find a widget named "CutButton" */

  if (!(CutButton = XtNameToWidget(MainForm->me, "CutButton")))
    no_mi = 1;
  if (!(CopyButton = XtNameToWidget(MainForm->me, "CopyButton")))
    no_mi = 1;
  if (!(PasteButton = XtNameToWidget(MainForm->me, "PasteButton")))
    no_mi = 1;
  if (!(DeleteButton = XtNameToWidget(MainForm->me, "DeleteButton")))
    no_mi = 1;
  if (!(DrawArea = XtNameToWidget(MainForm->me, "DrawingArea")))
    no_mi = 1;

  /* if we found both widgets then add a callback to the button. This
     is called whenever the user clicks the button. If there was no
     button and/or no text box then we avoid adding the callback. */

  if (!no_mi)
  {
    XtAddCallback(CutButton, XmNactivateCallback, cut_callback, NULL);
    XtAddCallback(CopyButton, XmNactivateCallback, copy_callback, NULL);
    XtAddCallback(PasteButton, XmNactivateCallback, paste_callback, NULL);
    XtAddCallback(DeleteButton, XmNactivateCallback, delete_callback, NULL);
  }


  /* Bring the application window up on the screen. */

  XtRealizeWidget(TopLevel);

  /* initialize visual clipboard  - mg library stuff (gl or vanilla-x)*/

  clipboard_init(MainForm->me);

  /* Begin main Intrinsics event loop */

  XtAppMainLoop (App);

}

void cut_callback(Widget w, XtPointer data, XmPushButtonCallbackStruct *cbs)
{
  char tmp;
  int  count;

  fprintf(stdout,"(echo (real-id target))\n");
  fflush(stdout);
  tmp = '\0';
  while (tmp != '\"')
    tmp = (char)fgetc(stdin);
  tmp = '\0';
  count = 0;
  while (tmp != '\"')
  {
    tmp = (char)fgetc(stdin);
    obj_name[count] = tmp;
    count++;
  }

  obj_name[count-1] = '\0';
   
  fprintf(stdout,"(write geometry - target)\n");
  fflush(stdout);
  theObject = GeomFLoad(stdin, obj_name);

  fprintf(stdout,"(delete target)\n");
  fflush(stdout);

  clipfull = 1;
  redraw(w);

}
void copy_callback(Widget w, XtPointer data, XmPushButtonCallbackStruct *cbs)
{
  char tmp;
  int  count;

  fprintf(stdout,"(echo (real-id target))\n");
  fflush(stdout);
  tmp = '\0';
  while (tmp != '\"')
    tmp = (char)fgetc(stdin);
  tmp = '\0';
  count = 0;
  while (tmp != '\"')
  {
    tmp = (char)fgetc(stdin);
    obj_name[count] = tmp;
    count++;
  }

  obj_name[count-1] = '\0';

  fprintf(stdout,"(write geometry - target)");
  fflush(stdout);
  theObject = GeomFLoad(stdin, obj_name);

  clipfull = 1;
  redraw(w);

}

void paste_callback(Widget w, XtPointer data, XmPushButtonCallbackStruct *cbs)
{
  if (clipfull == 0)
    return;

  fprintf(stdout,"(new-geometry %s {",obj_name);
  GeomFSave(theObject, stdout, obj_name);
  fprintf(stdout,"})");
  fflush(stdout);

}

void delete_callback(Widget w, XtPointer data, XmPushButtonCallbackStruct *cbs)
{
  char		tmp;

  fprintf(stdout,"(delete target)\n");
  fflush(stdout);

}
