#ifndef CRAYOLAP_H
#define CRAYOLAP_H

#include "crayola.h"

#define CRAYOLA_MAXNAME 128

/* 
 * WARNING:  The order of the names of the routines is hardcoded
 * into the functions themselves.
 */
#define CRAYOLA_MAXMETH 15
#define CRAYOLA_METHNAMES "crayHasColor", "crayHasVColor", "crayHasFColor", \
"crayCanUseVColor", "crayCanUseFColor", \
"crayUseVColor", "crayUseFColor", "crayEliminateColor", \
"craySetColorAll", \
"craySetColorAt", "craySetColorAtV", "craySetColorAtF", \
"crayGetColorAt", "crayGetColorAtV", "crayGetColorAtF"

typedef struct {
  char name[CRAYOLA_MAXNAME];
  GeomExtFunc *func;
} craySpecFunc;

void crayInitSpec(craySpecFunc *specfunc, int n_func, GeomClass *class);

void *crayTrue(int sel, Geom *geom, va_list args);
void *crayFalse(int sel, Geom *geom, va_list args);

#endif
