
/* File:	anytoucd.c:
   Author:	Charlie Gunn originally
                
   read a OOGL object on stdin, and write ucd format on stdout.
*/
#include "vec4.h"
#include "geom.h"
#include "ooglutil.h"
#include "3d.h"
#include "polylistP.h"
#include "plutil.h"
#include <stdio.h>
#include "time.h"

/*
#define DEBUG
*/

typedef struct {
    int id;
    HPoint3 v;
    }  ucdvert;

typedef struct {
    int id;
    int m;
    int n;
    int vlist[4];
    }  ucdpoly;

int
getcellsize(str)
char *str;
{
    if (strcmp(str,"line") == 0)  return(2);
    else if (strcmp(str,"tri") == 0)  return(3);
    else if (strcmp(str,"quad") == 0)  return(4);
    else return(0);
}

#define UCD_NORMAL	1
#define UCD_RGBA	2
#define UCD_RGB		3
#define UCD_Z		4
#define UCD_NUMDATAFIELDS	8

int 
gettype(str)
char *str;
{
    if (strcmp(str, "normal") == 0) return UCD_NORMAL; 
    else if (strcmp(str, "rgba") == 0) return UCD_RGBA; 
    else if (strcmp(str, "rgb") == 0) return UCD_RGB; 
    else return(0);
}

int
nodeidtoindex(id, v, num_nodes)
int id;
ucdvert *v;
int num_nodes;
{
    int i;
    for (i=0; i<num_nodes; ++i)	
	if (v[i].id == id) return(i);
    return(-1);
}

int
cellidtoindex(id, p, num_cells)
int id;
ucdpoly *p;
int num_cells;
{
    int i;
    for (i=0; i<num_cells; ++i)	
	if (p[i].id == id) return(i);
    return(-1);
}
main(argc, argv)	int argc; char **argv;
{
    FILE *fp = stdin;
    int num_nodes, 
	num_node_data_comp,
	*node_data_comp = NULL,
	num_cells, 
	num_cell_data_comp,
	num_model_data,
	*cell_data_comp = NULL,
	buff[5], 
	i,j,k,id,index,n, plflags = 0;
    HPoint3 *verts;
    int *nverts, *vertlist;
    Point3 *normal = NULL;
    ColorA *color = NULL;
    ucdvert *ucdv;
    ucdpoly *ucdp;
    char str[UCD_NUMDATAFIELDS][32], label[UCD_NUMDATAFIELDS][32];
    PolyList *mypl;

    {
    char *timestring;
    long mytime;
    time_t myt;
    myt = time(&mytime);
    timestring = ctime(&myt);
    fprintf(fp,"#  Created by ucdtooff on %s \n",timestring);
    }

    {
    int buff[5];
    /* get the header; fgetni skips ucd comments  */
    fgetni(fp,5,buff,0);
    num_nodes = buff[0];
    num_cells = buff[1];
    num_node_data_comp = buff[2];
    num_cell_data_comp = buff[3];
    num_model_data = buff[4];
    }

    ucdv  = OOGLNewN(ucdvert, num_nodes); 
    verts = OOGLNewN(HPoint3, num_nodes); 
    nverts = OOGLNewN(int, num_cells); 
    ucdp = OOGLNewN(ucdpoly, num_cells); 
    vertlist = OOGLNewN(int, 4*num_cells); 	/* assume no face has more than 4 vertices */
    if (num_node_data_comp)
        node_data_comp = OOGLNewN(int, num_node_data_comp);
    if (num_cell_data_comp)
        cell_data_comp = OOGLNewN(int, num_cell_data_comp);

    /* read the vertices */
    for (i=0; i<num_nodes; ++i)
 	{
	fscanf(fp,"%d%g%g%g",&ucdv[i].id,&ucdv[i].v.x,&ucdv[i].v.y,&ucdv[i].v.z);
	ucdv[i].v.w = 1.0;
	}
    /* translate the id's into indices */
    for (i=0; i<num_nodes; ++i)	{
	index = nodeidtoindex(ucdv[i].id, ucdv, num_nodes); 
	if (index < 0) OOGLError(1,"Bad node id %d in ucdtooff\n",id);
	verts[index] = ucdv[i].v;
	}

    /* read the faces */
    for (i=0; i<num_cells; ++i)	{
	fscanf(fp,"%d",&ucdp[i].id);
	fscanf(fp,"%d",&ucdp[i].m);	/* unused ? */
	fscanf(fp,"%s",str);
	ucdp[i].n = getcellsize(str);
	for (j=0; j<ucdp[i].n; ++j)
	    fscanf(fp,"%d",&ucdp[i].vlist[j]);
	}
    /* translate the id's into indices */
    {
    int total;
    for (total = 0, i=0; i<num_cells; ++i)	{
	for (j=0; j<ucdp[i].n; ++j)	{
	    index = nodeidtoindex(ucdp[i].vlist[j], ucdv, num_nodes); 
	    if (index < 0) OOGLError(1,"Bad node id %d in ucdtooff\n",id);
	    nverts[i] = ucdp[i].n;
	    vertlist[total++] = nodeidtoindex(ucdp[i].vlist[j], ucdv, num_nodes); 
	    }
	}
    }

    /* theoretically, we could get a reasonable polylist at this point */
	
    /* get the node data descriptor */
  if (num_node_data_comp != 0)  {
    fscanf(fp,"%d", &num_node_data_comp);
    for (i=0; i<num_node_data_comp; ++i)
        fscanf(fp,"%d", &node_data_comp[i]);

    /* get the node labels */
    for (i=0; i<num_node_data_comp; ++i)	{
	fscanf(fp,"%s",str+i);
	fscanf(fp,"%s",label+i);	/* this is ignored */
	}

    /* get the node data */
    for (i=0; i<num_node_data_comp; ++i)	{
	n = strlen(str[i]);
	/* get rid of commas */
  	if (str[i][n-1] == ',')  str[i][n-1] = '\0';
	switch (gettype(str[i]))	{
	    case UCD_NORMAL:
		if (node_data_comp[i] != 3)
		    OOGLError(1,"ucdtooff: bad normal descriptor\n");
		plflags |= PL_HASVN;
		normal = OOGLNewN(Point3, num_nodes);	
		for (j=0;j<num_nodes; ++j)	{
		    fscanf(fp,"%d",&id);
		    index = nodeidtoindex(id, ucdv, num_nodes);
		    if (index < 0) OOGLError(1,"Bad node id %d in ucdtooff\n",id);
		    fscanf(fp,"%g%g%g",&normal[index].x,&normal[index].y,&normal[index].z);
		    }
		break;

	    case UCD_RGBA:
		if (node_data_comp[i] != 4)
		    OOGLError(1,"ucdtooff: bad colora descriptor\n");
		plflags |= PL_HASVCOL;
		color = OOGLNewN(ColorA, num_nodes);	
		for (j=0;j<num_nodes; ++j)	{
		    fscanf(fp,"%d",&id);
		    index = nodeidtoindex(id, ucdv, num_nodes);
		    if (index < 0) OOGLError(1,"Bad node id %d in ucdtooff\n",id);
		    fscanf(fp,"%g%g%g%g",&color[index].r,&color[index].g,&color[index].b, &color[index].a);
		    } 
		break;

	    case UCD_RGB:
		if (node_data_comp[i] != 3)
		    OOGLError(1,"ucdtooff: bad color descriptor\n");
		plflags |= PL_HASVCOL;
		color = OOGLNewN(ColorA, num_nodes);	
		for (j=0;j<num_nodes; ++j)	{
		    fscanf(fp,"%d",&id);
		    index = nodeidtoindex(id, ucdv, num_nodes);
		    if (index < 0) OOGLError(1,"Bad node id %d in ucdtooff\n",id);
		    fscanf(fp,"%g%g%g",&color[index].r,&color[index].g,&color[index].b);
		    color[index].b = 1.0;
		    }
		break;
	    default:
		{
		float tt;
		fprintf(stderr,"ucdtooff: unknown type %s\n",str[i]);
		/* skip over the data */
		for (j=0;j<num_nodes; ++j)	{
		    fscanf(fp,"%d",&id);
		    for (k=0;k<node_data_comp[i]; ++k)	
			fscanf(fp,"%g",&tt);
		    }
		}
		break;
	    }	
	}
    }

    /* get the cell data descriptor */
  if (num_cell_data_comp != 0)  {
    fscanf(fp,"%d", &num_cell_data_comp);
    for (i=0; i<num_cell_data_comp; ++i)
        fscanf(fp,"%d", &cell_data_comp[i]);

    /* get the cell labels */
    for (i=0; i<num_cell_data_comp; ++i)	{
	fscanf(fp,"%s",str+i);
	fscanf(fp,"%s",label+i);	/* this is ignored */
	}

    /* get the cell data */
    for (i=0; i<num_cell_data_comp; ++i)	{
	n = strlen(str[i]);
	/* get rid of commas */
  	if (str[i][n-1] == ',')  str[i][n-1] = '\0';
	switch (gettype(str[i]))	{
	    case UCD_NORMAL:
		if (cell_data_comp[i] != 3)
		    OOGLError(1,"ucdtooff: bad normal descriptor\n");
		plflags |= PL_HASPN;
		normal = OOGLNewN(Point3, num_cells);	
		for (j=0;j<num_cells; ++j)	{
		    fscanf(fp,"%d",&id);
		    index = cellidtoindex(id, ucdp, num_cells);
		    if (index < 0) OOGLError(1,"Bad cell id %d in ucdtooff\n",id);
		    fscanf(fp,"%g%g%g",&normal[index].x,&normal[index].y,&normal[index].z);
		    }
		break;

	    case UCD_RGBA:
		if (cell_data_comp[i] != 4)
		    OOGLError(1,"ucdtooff: bad colora descriptor\n");
		plflags |= PL_HASPCOL;
		color = OOGLNewN(ColorA, num_cells);	
		for (j=0;j<num_cells; ++j)	{
		    fscanf(fp,"%d",&id);
		    index = cellidtoindex(id, ucdp, num_cells);
		    if (index < 0) OOGLError(1,"Bad cell id %d in ucdtooff\n",id);
		    fscanf(fp,"%g%g%g%g",&color[index].r,&color[index].g,&color[index].b, &color[index].a);
		    } 
		break;

	    case UCD_RGB:
		if (cell_data_comp[i] != 3)
		    OOGLError(1,"ucdtooff: bad color descriptor\n");
		plflags |= PL_HASPCOL;
		color = OOGLNewN(ColorA, num_cells);	
		for (j=0;j<num_cells; ++j)	{
		    fscanf(fp,"%d",&id);
		    index = cellidtoindex(id, ucdp, num_cells);
		    if (index < 0) OOGLError(1,"Bad cell id %d in ucdtooff\n",id);
		    fscanf(fp,"%g%g%g",&color[index].r,&color[index].g,&color[index].b);
		    color[index].b = 1.0;
		    }
		break;
	    default:
		{
		float tt;
		fprintf(stderr,"ucdtooff: unknown type %s\n",str[i]);
		/* skip over the data */
		for (j=0;j<num_cells; ++j)	{
		    fscanf(fp,"%d",&id);
		    for (k=0;k<cell_data_comp[i]; ++k)	
			fscanf(fp,"%g",&tt);
		    }
		}
		break;
	    }	
	}
    }

    {
    int cflag, nflag;
    Geom *mypl;

    if (plflags & PL_HASPCOL)  cflag = CR_POLYCOLOR;
    else if (plflags & PL_HASVCOL) cflag = CR_COLOR;
    else cflag = CR_COLOR;

    if (plflags & PL_HASPN)  nflag = CR_POLYNORMAL;
    else if (plflags & PL_HASVN) nflag = CR_NORMAL;
    else nflag = CR_NORMAL;

    mypl = GeomCreate("polylist",
                /*CR_NOCOPY,            isn't supported for polylists! */
                CR_NPOLY, num_cells,
                CR_NVERT, nverts,
                CR_VERT,  vertlist,
                CR_POINT4, verts,
                cflag, color,
                nflag, normal,
                CR_FLAG, plflags, CR_END
	 	);
    GeomFSave(mypl, stdout, NULL);
    }
}


