/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef _EVENT_H
#define _EVENT_H

#include <stdio.h>
#include "common.h"

typedef struct {
  PFI motionproc;	/* current motion proc */
  char *epath;		/* pathname of external motion program*/
  FILE *efp;
  Pool *epool;		/* stream for communication to extern motion program */
  int epid;		/* pid of external motion pgm, or 0 if none */
} EventState;

extern EventState estate;

/*
 * For keyboard keys, dev number = ascii value
 *
 * Other dev number:
 */

#define ELEFTMOUSE	500
#define EMIDDLEMOUSE	501
#define ERIGHTMOUSE	502
/*
 * values for mouse events:
 *   1: button went down
 *  -1: button dragged while down
 *   0: button went up
 */

#define EDRAW		503

#define EMODEENTER	504
#define EMODEEXIT	505

#define EPICK		506
#define EUISELECT	507

#define PICKWORLD	0
#define PICKOBJECT	1

/* State of buttons, maintained in event.c and potentially usable by
 * motion or other modules.
 */
extern struct button {
	char shift;
	char ctrl;
	char left, middle, right;
} button;

extern void event_init();

extern void MainLoop();
extern void print_help();

extern float elapsed(float *since, float *nextsince);

#endif /* ! _EVENT_H */

