/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef LANG_H
#define LANG_H

char *keywordname(int keyword);
int boolval(char *s, int keyword);
HandleOps *keyword2ops(int keyword);

typedef enum {
  NO_KEYWORD=0,
  YES_KEYWORD,
  ON_KEYWORD,
  OFF_KEYWORD,
  ZERO_KEYWORD,
  ONE_KEYWORD,
  NONE_KEYWORD,
  EACH_KEYWORD,
  KEEP_KEYWORD,
  ALL_KEYWORD,
  EUCLIDEAN_KEYWORD,
  HYPERBOLIC_KEYWORD,
  SPHERICAL_KEYWORD,
  VIRTUAL_KEYWORD,
  PROJECTIVE_KEYWORD,
  CONFORMALBALL_KEYWORD,
  TIFF_KEYWORD,
  FRAME_KEYWORD,
  CAMERA_KEYWORD,
  GEOM_KEYWORD,
  TRANSFORM_KEYWORD,
  COMMAND_KEYWORD,
  WINDOW_KEYWORD,
  TRANSLATE_KEYWORD,
  E_TRANSLATE_KEYWORD,
  H_TRANSLATE_KEYWORD,
  S_TRANSLATE_KEYWORD,
  TRANSLATE_SCALED_KEYWORD,
  E_TRANSLATE_SCALED_KEYWORD,
  H_TRANSLATE_SCALED_KEYWORD,
  S_TRANSLATE_SCALED_KEYWORD,
  ROTATE_KEYWORD,
  SCALE_KEYWORD,
  ZOOM_KEYWORD,
  HORIZONTAL_KEYWORD,
  VERTICAL_KEYWORD,
  COLORED_KEYWORD,
  TOGGLE_KEYWORD
} Keyword;

void lang_init();

#endif
