
#import <appkit/appkit.h>
#import <streams/streams.h>

#include "mg.h"
#include "drawer.h"
#include "ui.h"
#include "comm.h"
#include "motion.h"
#include "worldio.h"
#include "version.h"

#include "event.h"
int mousedragage;
Event event;

#include "lights.h"
#include "lang.h"
#include "mgri.h"

/* Panel definitions below must be in the same order! */
#define	P_MAIN		1
#define	P_TOOL		2
#define	P_INSPECTOR		3
#define	P_CAMERA	3
#define	P_LIGHTS	3
#define	P_COMMANDS	4
#define	P_SAVE		5
#define	P_INPUT		6
#define	P_MAX	7

struct panel {
    id panel;
    char *name;
    char *nick;
    int shown;
    int browse;
    int x0,y0;
};

extern struct panel panels[];

#define	SAVE_WIO	0
#define	SAVE_RMan	1
#define	SAVE_SNAP	2
#define	SAVE_PANELS	3

struct saveops {
    int special;
    HandleOps *ops;
    int flag;
    char *name;
};

extern void ui_final_init();
extern void timing(int interval);
extern struct saveops save[];
void ui_keyboard(int ch);

@interface GVApp:Application
{
  id browsersDel;
  id buttonsDel;
  id commandText;
  id pathBrowser;
  id saveTypeBrowser;
  id saveObject;
  id eventView;
  id mainPanelDel;
  id inspectorDel;
  id preferencesDel;
  id toolPanelDel;
  id infoPanel;
  id menuCloseCamera;

  id saveAccessory;
  id printCam;
}

- info:sender;
- preferences:sender;
- toolPanel:sender;
- panelMain:sender;
- inspector:sender;
- deleteObj:sender;
- deleteCamera:sender;
- halt:sender;
- addCamara:sender;
- center:sender;

- save:sender;
- open:sender;
- openBundle:sender;
- (int)browser:sender fillMatrix:theMatrix inColumn:(int)column;
- pathSelected:sender;
- makeKeyResponderFor:window;

- inspectorDel;
- preferencesDel;
- toolPanelDel;
- mainPanelDel;
- commandText;
- menuCloseCamera;
- saveTypeBrowser:sender;

- print:sender;
@end
