
#import "InspectorDel.h"
#import "GVApp.h"
#import "LimitedTextField.h"

#define NEXT_DRAWER_LIGHTSDRAW DRAWER_LIGHTCOLOR+1000
#import "drawer.h"

#import "../common/transform.h" 
// Need the ../common otherwise get the library header file

@implementation InspectorDel

// add this as a categorie ??
- (int)selectedRow:sender
{
  int index, notused;
  id matrix=[sender matrixInColumn:0];
  [matrix getRow:&index andCol:&notused ofCell:[matrix selectedCell]];
  return index;	
}

- init
{
  [super init];
  [NXApp loadNibSection:"Inspector.nib" owner:self withNames:NO];
  return self;
}

- awakeFromNib
{
  [NXApp makeKeyResponderFor:inspectorPanel];
  [inspectorPanel setBecomeKeyOnlyIfNeeded:YES];

  [inspectorBox setTitlePosition: NX_NOTITLE];
  [inspectorBox setBorderType: NX_NOBORDER];
  [inspectorBox setOffsets:0 :0];
  [[inspectorBox setContentView:[appearance contentView]] free];

  [faces setTag:DRAWER_FACEDRAW];
  [edges setTag:DRAWER_EDGEDRAW];
  [normals setTag:DRAWER_NORMALDRAW];
  [bBoxes setTag:DRAWER_BBOXDRAW];
	
  [faceColor setTag:DRAWER_DIFFUSE];
  [edgeColor setTag:DRAWER_EDGECOLOR];
  [normalColor setTag:DRAWER_NORMALCOLOR];
  [bBoxColor setTag:DRAWER_BBOXCOLOR];
  [lightColor setTag:DRAWER_LIGHTCOLOR];
  [backColor setTag:DRAWER_BACKCOLOR];
  [drawCamera setTag:DRAWER_CAMERADRAW];
  [drawSphere setTag:DRAWER_HSPHERE];
  
  [focus setTag:DRAWER_FOCALLENGTH];
  [linesCloser setTag:DRAWER_LINE_ZNUDGE];
  [patchDicing setTag:DRAWER_BEZDICE];
  [lineWidth setTag:DRAWER_LINEWIDTH];
  [normalLength setTag:DRAWER_NORMSCALE];
  [nearClip setTag:DRAWER_NEAR];
  [farClip setTag:DRAWER_FAR];
  [fov setTag:DRAWER_FOV];

  [patchDicing setEntryType:NX_INTTYPE withBounds:0 :999];
  [lineWidth setEntryType:NX_INTTYPE withBounds:1 :256];
  [normalLength setEntryType:NX_FLOATTYPE withBounds:0 :999.];

  [nearClip setEntryType:NX_FLOATTYPE withBounds:-1e20 :1e20];
  [farClip setEntryType:NX_FLOATTYPE withBounds:-1e20 :1e20];
  [focus setEntryType:NX_FLOATTYPE withBounds:1e-20 :1e20];
  [fov setEntryType:NX_FLOATTYPE withBounds:1e-6 :179.999];
  [linesCloser setEntryType:NX_FLOATTYPE withBounds:-10000 :10000];

  [ambient setTag:DRAWER_KA];
  [ambientS setTag:DRAWER_KA];
  [diffuse setTag:DRAWER_KD];
  [diffuseS setTag:DRAWER_KD];
  [specular setTag:DRAWER_KS];
  [specularS setTag:DRAWER_KS];
  [shininess setTag:DRAWER_SHININESS];
  [shininessS setTag:DRAWER_SHININESS];
    
  [shadingBrowser loadColumnZero];
  [normalizationBrowser loadColumnZero];
  [projectionBrowser loadColumnZero];
  [modelBrowser loadColumnZero]; 
  [self setSpace];
  [self appearance];
  [self camera];
  [self lights];
  return self;
}

- display 
{
  struct panel *p=&panels[P_INSPECTOR];
  if(p->x0>=0) [inspectorPanel moveTo:p->x0 :p->y0];
  p->x0 = -1;
  if(p->shown) {
    [self objectChange];
    [inspectorPanel orderFront:self];
  }
  else [inspectorPanel close];
  return self;
}

- appearance
{
  register DGeom *dg;
  register Appearance *ap;
  int revert = 0;

  if(uistate.lights_shown) return self;
  
  if (dg=(DGeom*)drawer_get_object(GEOMID(uistate.targetgeom))) {
    [inspectorPanel setTitle:"Geometry Inspector"];
    [targetName setStringValue:dg->name[1]];
    ap = drawer_get_ap(GEOMID(uistate.targetgeom));
    revert = ap->override;

    [faces setState:(ap->flag & APF_FACEDRAW) ? 1 : 0];
    [edges setState:(ap->flag & APF_EDGEDRAW) ? 1 : 0];
    [bBoxes setState:dg->bboxdraw];
    [normals setState:(ap->flag & APF_NORMALDRAW) ? 1 : 0];

    [faceColor setColor: NXConvertRGBAToColor(ap->mat->diffuse.r,
                         ap->mat->diffuse.g,
			 ap->mat->diffuse.b,NX_NOALPHA)];

    [edgeColor setColor: NXConvertRGBAToColor(ap->mat->edgecolor.r,
                         ap->mat->edgecolor.g,
			 ap->mat->edgecolor.b,NX_NOALPHA)];

    [normalColor setColor: NXConvertRGBAToColor(ap->mat->normalcolor.r,
                         ap->mat->normalcolor.g,
			 ap->mat->normalcolor.b,NX_NOALPHA)];

    [bBoxColor setColor: NXConvertRGBAToColor(dg->bboxap->mat->edgecolor.r,
                         dg->bboxap->mat->edgecolor.g,
			 dg->bboxap->mat->edgecolor.b,NX_NOALPHA)];
    
    [[normalizationBrowser matrixInColumn:0] 
                           selectCellAt:dg->normalization :0];
 
    [[shadingBrowser matrixInColumn:0] 
                           selectCellAt:ap->shading - CONSTANTSHADE :0];
    [lineWidth setDoubleValue:ap->linewidth];
    [normalLength setDoubleValue:ap->nscale];
    [patchDicing setDoubleValue:dg->bezdice];
//      may_set_ap_button( VectDrawButton, ap, APF_VECTDRAW);  

      if (ap->mat) {
	if(ap->mat->valid & MTF_Ka) {
	  [ambient setDoubleValue:ap->mat->ka];
	  [ambientS setDoubleValue:ap->mat->ka];
	}
	if(ap->mat->valid & MTF_Kd) {
	  [diffuse setDoubleValue:ap->mat->kd];
	  [diffuseS setDoubleValue:ap->mat->kd];
	}
	if(ap->mat->valid & MTF_Ks) {
	  [specular setDoubleValue:ap->mat->ks];
	  [specularS setDoubleValue:ap->mat->ks];
	}
	if(ap->mat->valid & MTF_SHININESS) {
	  [shininess setDoubleValue: ap->mat->shininess];
	  [shininessS setDoubleValue: ap->mat->shininess];
	}
      }

    ApDelete(ap);
  } 
  return self;
}

- camera
{
  register DView *dv;
  int i;
  float f;
  
  if(uistate.lights_shown) return self;

  if((dv = (DView *)drawer_get_object(TARGETID)) && ISCAM(dv->id)) {
    [inspectorPanel setTitle:"Camera Inspector"];
    [targetName setStringValue:dv->name[1]];
    [backColor setColor: NXConvertRGBAToColor(dv->backcolor.r,
                         dv->backcolor.g,
			dv->backcolor.b,NX_NOALPHA)];
    CamGet(dv->cam, CAM_NEAR, &f);
    [nearClip setDoubleValue:f];
    CamGet(dv->cam, CAM_FAR, &f);
    [farClip setDoubleValue:f];
    CamGet(dv->cam, CAM_FOCUS, &f);
    [focus setDoubleValue:f];
    CamGet(dv->cam, CAM_PERSPECTIVE, &i);
    [[projectionBrowser matrixInColumn:0] 
                           selectCellAt:i :0];
    CamGet(dv->cam, CAM_FOV, &f);	/* perspective -> degrees, */
    [fov setDoubleValue:f];
    [linesCloser setIntValue:(int)dv->lineznudge];
    [drawCamera setState:dv->cameradraw];
    [softShading setState:dv->shader !=NULL];
            
    [drawSphere setState:dv->hsphere!=NULL];
    [[modelBrowser matrixInColumn:0] selectCellAt:dv->hmodel :0];
  } 
  return self;
}

- lights
{
  extern Color *light_color();
  extern float light_intensity();
  Color *color;
  NXColor aColor;
  double value;
  char buf[32];
  
  [inspectorPanel setTitle:"Light Inspector"];
  if(uistate.current_light==0) sprintf(buf,"ambient");
  else sprintf(buf,"light %d", uistate.current_light);
  [targetName setStringValue:buf];
  color = light_color();
  aColor = NXConvertRGBAToColor(color->r, color->g, color->b, NX_NOALPHA);
  [lightColor setColor:aColor];

  value = light_intensity();
  [lightIntensity setDoubleValue:value];
  [lightIntensityField setDoubleValue:value];

  return self;
}

- lightColor:sender
{
  Color curcol = {0, 0, 0};

  NXConvertColorToRGBA([sender color], &curcol.r, &curcol.g, &curcol.b, NULL);
  set_light_color(&curcol);
  return self;
}

- lightIntesity:sender
{
  float f;
  f = [sender doubleValue];
  [lightIntensityField setFloatValue:f];
  [lightIntensity setFloatValue:f];
  drawer_float(GEOMID(uistate.targetgeom), DRAWER_LIGHT_INTENSITY, f);
  return self;
}

- color:sender
{
  int curval=[sender tag];
  Color curcol = {0, 0, 0};

  NXConvertColorToRGBA([sender color], &curcol.r, &curcol.g, &curcol.b, NULL);
  if (curval == DRAWER_BBOXCOLOR) {
    gv_bbox_color( GEOMID(uistate.targetgeom), curcol.r, curcol.g, curcol.b );
  } else {
    drawer_color(GEOMID(uistate.targetgeom), curval, &curcol);
  }
  return self;
}

- objectChange
{
  if ((drawer_cam_count()) > 1) {
    [drawCamera setEnabled:YES];
  } else {
    [drawCamera setEnabled:NO];
  }
  [self targetChange];
  return self;
}

- targetChange
{
  if(uistate.lights_shown) {
    [self lights];
    [inspectorBox setContentView:[lights contentView]];
  }
  else {
    if(ISGEOM(uistate.targetid)) {
    [self appearance];
    [inspectorBox setContentView:[appearance contentView]];
    }
    else if(ISCAM(uistate.targetid)) {
    [self camera];
    [inspectorBox setContentView:[camera contentView]];
    }
  }
  [inspectorBox update];
  return self;
}

- mouseFocus
{
  if((uistate.targetid==FOCUSID)||(real_id(uistate.targetid)==FOCUSID)) 
    [self camera];
  return self;
}

- toggleButton:sender
{
  int tag,onoff;
  tag  = [sender tag];
  onoff = [sender state];
  drawer_int(GEOMID(uistate.targetgeom), tag, onoff);
  return self;
}

- revert:sender
{
  drawer_set_ap( GEOMID(uistate.targetgeom), NULL, NULL );
  return self;
}

- dice:sender
{
  gv_dice(GEOMID(uistate.targetgeom),[sender intValue]);
  return self;
}

- normalLength:sender
{
  drawer_float(GEOMID(uistate.targetgeom),DRAWER_NORMSCALE,[sender doubleValue]);
  return self;
}

- lineWidth:sender
{
//  gv_line_width(GEOMID(uistate.targetgeom),[sender doubleValue]);
  drawer_int(GEOMID(uistate.targetgeom),DRAWER_LINEWIDTH,[sender doubleValue]);
  return self;
}

- materials:sender
{
  drawer_float(GEOMID(uistate.targetgeom), [sender tag], [sender doubleValue]);
  return self;
}

- cameraField:sender
{ 
  drawer_float(TARGETID, [sender tag], [sender doubleValue]);
  return self;
}

- softShading:sender
{ 
  gv_soft_shader(TARGETID, [sender state] ? ON_KEYWORD : OFF_KEYWORD);
  return self;
}

- backgroundColor:sender
{
  int curval=[sender tag];
  Color curcol = {0, 0, 0};

  NXConvertColorToRGBA([sender color], &curcol.r, &curcol.g, &curcol.b, NULL);
  gv_backcolor( TARGETID, curcol.r, curcol.g, curcol.b );
  return self;
}

- drawOtherCameras:sender
{
  drawer_int(TARGETID, DRAWER_CAMERADRAW, [sender state]);
  return self;
}

- drawSphere:sender
{
  drawer_int(real_id(TARGETID), DRAWER_HSPHERE, [sender state] );
  return self;
}

- shadingBrowser:sender
{
  int index=[self selectedRow:sender];
  drawer_int(GEOMID(uistate.targetgeom), DRAWER_SHADING, 
                                    index + CONSTANTSHADE);
  return self;
}

- normalizationBrowser:sender
{
  int i=[self selectedRow:sender];
  drawer_int(GEOMID(uistate.targetgeom),DRAWER_NORMALIZATION,i);
  return self;
}

- projectionBrowser:sender
{
  int i=[self selectedRow:sender];
  drawer_int( TARGETID, DRAWER_PROJECTION, i );
  return self;
}

- modelBrowser:sender
{
  int i=[self selectedRow:sender];
  gv_hmodel(real_id(TARGETID), hmodelkeyword("ModelBrowserProc", i));
  return self;
}

- (int)browser:sender fillMatrix:theMatrix inColumn:(int)column
{
  int i;
  NXBrowserCell *bCell;
  if(sender==shadingBrowser) {
    for(i=0;i<COUNT(shades);i++) {
      [theMatrix addRow];
      bCell=[theMatrix cellAt:i :0];
      [bCell setStringValue:shades[i]];
      [bCell setLoaded:YES];
      [bCell setLeaf:YES];
    }
    return COUNT(shades);
  }
  else if(sender==normalizationBrowser) {
    for(i=0;i<COUNT(norm);i++) {
      [theMatrix addRow];
      bCell=[theMatrix cellAt:i :0];
      [bCell setStringValue:norm[i]];
      [bCell setLoaded:YES];
      [bCell setLeaf:YES];
    }
    return COUNT(norm);
  }
  else if(sender==projectionBrowser) {
    for(i=0;i<COUNT(proj);i++) {
      [theMatrix addRow];
      bCell=[theMatrix cellAt:i :0];
      [bCell setStringValue:proj[i]];
      [bCell setLoaded:YES];
      [bCell setLeaf:YES];
    }
    return COUNT(proj);
  }
  else if(sender==modelBrowser) {
    for(i=0;i<COUNT(mdl);i++) {
      [theMatrix addRow];
      bCell=[theMatrix cellAt:i :0];
      [bCell setStringValue:mdl[i]];
      [bCell setLoaded:YES];
      [bCell setLeaf:YES];
    }
    return COUNT(mdl);
  }
  return 0;
}

- setSpace
{
  [modelBrowser update];
  return self;
}

- window {return inspectorPanel;}
@end
