#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <math.h>
#include <stdio.h>

class vertex
{
 public:
 vertex();
 void read_vertex(int, FILE *);
 void read_cvertex(int, FILE *);
 void read_cnvertex(int, FILE *);
 vertex *next;
 double x,y,z;
 float vr,vg,vb;
 int clip;
 int num;
};

class vertex_list
{
 public:
 vertex_list();
 void read_vertices(int, FILE *);
 void write_vertices(FILE *);
 void clip_vertex(int, char**);
 void put_in_array(vertex **);
 vertex *add_vertex(double, double, double, float, float, float);
 void refresh_vertex_list();
 int numvtx;
 double a,b,c,d;
 int ptype;
 int side;

 private:
 vertex *head;
 vertex *point;
};

class pvtx
{
 public:
 pvtx();
 void read_pvtx(FILE *);
 int num;
 vertex *me;
 pvtx *next;
};

class polyvtx_list
{
 public:
 polyvtx_list();
 void read_polyvtx(int, FILE *);
 void write_polyvtx(FILE *);
 int find_unclipped_vertex(vertex **);
 int clip_each_vertex(vertex_list *, vertex **);
 int numvtx;

 private:
 pvtx *head;
 pvtx *point;
};

 
class poly
{
 public:
 poly();
 void read_poly(FILE *);
 void clip_poly(vertex_list * cli, vertex **);
 int numvtx;
 int clipped;
 polyvtx_list *me;
 float r,g,b,tr;
 poly *next;
};

class poly_list
{
 public:
 poly_list();
 void read_polys(int, FILE *);
 void write_polys(FILE *);
 void clip_polys(vertex_list *);
 void refresh_poly_list();
 int numpoly;
 int ptype;

 private:
 poly *head;
 poly *point;
};

void main_clip(int, char *[]);
