#include <stdio.h>
#include <math.h>
#include "graffiti.h"

#define MAXVERTS 1000

int newvect = 1;
int wrap = 0;
short nverts = 0;
Point3 verts[MAXVERTS];
int onlyverts = 0;
char *headname = "graffiti-head";
char *tailname = "graffiti-tail";
char *headxformname = "graffiti-head-xform";
char *tailxformname = "graffiti-tail-xform";
char *graffitiname = "graffiti";


/*
*main(int argc, char *argv[])
*{
*  Initialize();
*  gui_init();
*  gui_main_loop();
*}
*/

NewPLine()
{
  nverts = 0;
}

NewLine()
{
  if (!newvect) {
    EraseHeadAndTail();
    StartNewVector();
    NewPLine();
    newvect = 1;
    wrap = 0;
  }
}

void
Initialize()
{
  LangInit(stdout);
  NewPLine();
}

void
AddVertex(Point3 *p)
{
  progn();

  /* if this is the first vertex of this pline, draw the tail here */
  if (nverts == 0) {
    ShowTailAt(p);
  } else {
    /* otherwise draw the head here, pointing along last segment */
    ShowHeadAt(p, &verts[nverts-1]);
  }

  if (nverts < MAXVERTS) {
    verts[nverts] = *p;
    ++nverts;
  }
  Geometry();
  endprogn();
}

RemoveVertex()
{
  if (!nverts) return;
  --nverts;

  progn();
  Geometry();
  if (nverts == 0) { /* if we are down to 0 vertices, nuke head and tail */
    EraseHeadAndTail();
  } else if (nverts == 1) { /* if just 1 vertex nuke head */
    EraseHead();
  } else if (nverts > 1) { /* if > 1 vertex, move head to last one */
    ShowHeadAt(&verts[nverts-1], &verts[nverts-2]);
  }
  endprogn();
}

Close()
{
  wrap = 1;
  Geometry();
}
