#include <stdlib.h>
#include "geom.h"
#include "polylistP.h"
#include "hpoint3.h"
#include "plutil.h"

static char msg[] = "sortbyz.c";

#define min(a, b) ((a) < (b) ? (a) : (b))
#define max(a, b) ((a) > (b) ? (a) : (b))

typedef struct {
  HPt3Coord close;
  HPt3Coord far;
  Poly *p;
  } Element;

int ElementCmp(a, b)
Element *a, *b;
{
  if (a->far < b->far) return -1;
  if (a->far > b->far) return 1;
  if (a->close < b->close) return -1;
  if (a->close > b->close) return 1;
  return 0;
} 

Geom *SortByZ(Geom *g) {
  int i, j;
  PolyList *p;
  Element *e;
  Poly *n;

  p = (PolyList *)AnyToPL(g, TM_IDENTITY);

  e = (Element *)OOG_NewE(p->n_polys * sizeof(Element), msg);
  for (i = 0; i < p->n_polys; i++) {
    e[i].p = &p->p[i];
    if (e[i].p->n_vertices) {
      e[i].close = e[i].p->v[0]->pt.z;
      e[i].far = e[i].p->v[0]->pt.z;
      for (j = 0; j < e[i].p->n_vertices; j++) {
	e[i].close = max(e[i].close, e[i].p->v[j]->pt.z);
	e[i].far = min(e[i].far, e[i].p->v[j]->pt.z);
      }
    }
  }

  qsort(e, p->n_polys, sizeof(Element), ElementCmp);

  n = (Poly *)OOG_NewE(p->n_polys * sizeof(Poly), msg);

  for (i = 0; i < p->n_polys; i++) bcopy(e[i].p, &n[i], sizeof(Poly));

  OOGLFree(p->p);
  p->p = n;

  OOGLFree(e);

  return((Geom *)p);

}


