#import <stdio.h>
#import "camera.h"
#import "geom.h"
#import "ooglutil.h" 
#import "pssnap.h"
#import "PSSnapshot.h"

@implementation PSSnapshot

- save:sender
{
	FILE *outfile = stdout, *infile = stdin;
	Camera *c;
	Geom *o, *onew;
	int flag;

	if ((outfile = fopen([filename stringValueAt:0], "w")) == NULL) {
		OOGLError(1, "Unable to open output file %s.",
			  [filename stringValueAt:0]); 
		exit(1);
	}

	printf("(write geometry - targetgeom)\n");
	fflush(stdout);
	o = GeomFLoad(stdin, NULL);

	printf("(write camera - targetcam)\n");
	fflush(stdout);
	c = CamFLoad(NULL, stdin, "stdin");

	flag = 0;
	flag |= [DrawEdges state] ? PS_EDGES : 0;
	flag |= [DrawFaces state] ? PS_FACES: 0;
	flag |= [UseColor state] ? PS_COLOR : 0;

	onew = PolyProject(o, c);
 
  	PolyToPSInit(outfile, flag);
  	PolyToPS(onew, outfile, flag);
  	fprintf(outfile, "showpage\n");
 
  	fclose(outfile);

	GeomDelete(o);
	GeomDelete(onew);
	CamDelete(c);

    return self;
}

-saveas:sender
{

  SavePanel *savepanel;

  savepanel = [SavePanel new];
  if (![savepanel runModal]) return self;

  [filename setStringValue:[savepanel filename] at:0];
  [self save:0 ];

  return self;
}

-appDidInit:sender
{
	[NXApp activateSelf:1];
	return self;
}


@end
