/* 
 * pssnap.main.c
 * author:  Celeste Fowler
 * date:  June 12, 1992
 */

#include <stdio.h>
#include "geom.h"
#include "polylistP.h"
#include "camera.h"
#include "forms.h"
#include "pssnap.h"

#define min(a, b) ((a) < (b) ? (a) : (b))
#define max(a, b) ((a) > (b) ? (a) : (b))

int flag = PS_EDGES | PS_FACES | PS_COLOR;
FL_FORM *MainForm;
FL_OBJECT *SaveButton, *QuitButton, *FaceDrawButton, *EdgeDrawButton,
  *ColorDrawButton, *FileInput;

void SaveProc(FL_OBJECT *obj, long val);
void QuitProc(FL_OBJECT *obj, long val);
void OptionsProc(FL_OBJECT *obj, long val);

main(int argc, char *argv[]) {
  foreground();

  MainForm = fl_bgn_form(FL_NO_BOX, 300, 200);
  fl_add_box(FL_UP_BOX, 0, 0, 300, 200, "");

  SaveButton = fl_add_lightbutton(FL_PUSH_BUTTON, 25, 20, 100, 40,
			     "Save");
  fl_set_call_back(SaveButton, SaveProc, 0);

  QuitButton = fl_add_button(FL_NORMAL_BUTTON, 175, 20, 100, 40,
			     "Quit");
  fl_set_call_back(QuitButton, QuitProc, 0);

  FaceDrawButton = fl_add_lightbutton(FL_PUSH_BUTTON, 0, 160, 100, 40,
				 "Draw Faces");
  fl_set_object_lsize(FaceDrawButton, FL_SMALL_FONT); 
  fl_set_call_back(FaceDrawButton, OptionsProc, PS_FACES);
  fl_set_button(FaceDrawButton, 1);

  EdgeDrawButton = fl_add_lightbutton(FL_PUSH_BUTTON, 100, 160, 100, 40,
				"Draw Edges");
  fl_set_object_lsize(EdgeDrawButton, FL_SMALL_FONT); 
  fl_set_call_back(EdgeDrawButton, OptionsProc, PS_EDGES);
  fl_set_button(EdgeDrawButton, 1);

  ColorDrawButton = fl_add_lightbutton(FL_PUSH_BUTTON, 200, 160, 100, 40,
				  "Use Color");
  fl_set_object_lsize(ColorDrawButton, FL_SMALL_FONT); 
  fl_set_call_back(ColorDrawButton, OptionsProc, PS_COLOR);
  fl_set_button(ColorDrawButton, 1);

  FileInput = fl_add_input(FL_NORMAL_INPUT, 25, 80, 250, 40, 
			   "Filename:");
  fl_set_input(FileInput, "snap.ps");
  fl_set_object_align(FileInput, FL_ALIGN_TOP);
  fl_end_form();
  fl_show_form(MainForm, FL_PLACE_SIZE, TRUE, "PS Snapshot");
    
  while(1) fl_do_forms();

}


void SaveProc(FL_OBJECT *obj, long val)
{
  int i;
  FILE *outfile = stdout, *infile = stdin;
  Camera *c;
  Geom *o, *onew;
 
  /* Get the current object. */
  printf("(write geometry - targetgeom )\n");
  fflush(stdout);
  
  if ((outfile = fopen(fl_get_input(FileInput), "w")) == NULL) {
    OOGLError(0, "Unable to open output file %s", fl_get_input(FileInput));
    exit(1);
  }

  o = GeomFLoad(stdin, NULL);
  
  printf("(write camera - targetcam)\n");
  fflush(stdout);
  
  c = CamFLoad(NULL, stdin, "stdin");  
  
  /* Do the viewing transformations. */
  onew = PolyProject(o, c);
  GeomDelete(o);

  PolyToPSInit(outfile, flag);
  PolyToPS(onew, outfile, flag);
  fprintf(outfile, "showpage\n");
 
  fclose(outfile);

  GeomDelete(onew);

  fl_set_button(SaveButton, 0);

}  
  

void QuitProc(FL_OBJECT *obj, long val) 
{
  exit(0);
}


void OptionsProc(FL_OBJECT *obj, long val)
{
  flag ^= val;
} 





