#include <stdio.h>
#include <math.h>
#include "forms.h"
#include "geom.h"
#include "point3.h"
#include "formsx.h"
#include "panel.h"
#include "sweep.h"

main() {

  foreground();

  create_the_forms();
  fl_set_button(TransSweep, 1);
  fl_set_button(RadButton, 1);

  flx_set_input_printf(Transxdir, "%.2f", 0.0);
  flx_set_input_printf(Transydir, "%.2f", 0.0);
  flx_set_input_printf(Transzdir, "%.2f", 1.0);
  flx_set_input_printf(Translength, "%.2f", 1.0);
  
  flx_set_input_printf(Rotlength, "%.2f", 2.0 * M_PI);
  flx_set_input_int(Rotdivisions, 10);
  flx_set_input_float(Rotendx, 0.0);
  flx_set_input_float(Rotendy, 0.0);
  flx_set_input_float(Rotendz, 0.0);
  flx_set_input_float(Rotdirx, 0.0);
  flx_set_input_float(Rotdiry, 1.0);
  flx_set_input_float(Rotdirz, 0.0);

  fl_hide_object(RotGroup);

  fl_show_form(MainForm, FL_PLACE_SIZE, TRUE, "Sweep");
  while(1) fl_do_forms();
}


void RotSweepProc(FL_OBJECT *obj, long val) {
  fl_hide_object(TransGroup);
  fl_show_object(RotGroup);
}


void TransSweepProc(FL_OBJECT *obj, long val) {
  fl_hide_object(RotGroup);
  fl_show_object(TransGroup);
}


void GoButtonProc(FL_OBJECT *obj, long val) {
  Geom *g, *s;
  Point3 pt1, pt2;

  printf("(write geometry - targetgeom bare)");
  fflush(stdout);
  g = GeomFLoad(stdin, NULL);

  if (fl_get_button(RotSweep)) {
    pt1.x = flx_get_input_float(Rotendx);
    pt1.y = flx_get_input_float(Rotendy);
    pt1.z = flx_get_input_float(Rotendz);
    pt2.x = flx_get_input_float(Rotdirx);
    pt2.y = flx_get_input_float(Rotdiry);
    pt2.z = flx_get_input_float(Rotdirz);
    s = RotationSweep(flx_get_input_float(Rotlength) * 
		      (fl_get_button(DegButton) ? M_PI / 180.0 : 1.0), 
		      &pt1, &pt2, 
		      flx_get_input_int(Rotdivisions), g);
  } else {
    pt1.x = flx_get_input_float(Transxdir);
    pt1.y = flx_get_input_float(Transydir);
    pt1.z = flx_get_input_float(Transzdir);
    s = TranslationSweep(flx_get_input_float(Translength), &pt1, g);
  }

  if (s != NULL) {
    printf("(geometry sweep { ");
    GeomFSave(s, stdout, NULL);
    printf(" } ) ");
    fflush(stdout);
  }
  GeomDelete(g);
  GeomDelete(s);
		       
}

void QuitButtonProc(FL_OBJECT *obj, long val) {
  exit(0);
}
