#include <stdio.h>
#include "geom.h"
#include "streampool.h"
#include "forms.h"
#include "panel.h"

static Pool *standardIn, *standardOut;

main() {

  foreground();

  standardIn = PoolStreamTemp(NULL, stdin, 0, NULL);
  standardOut = PoolStreamTemp(NULL, stdout, 1, NULL);

  create_the_forms();
  fl_set_button(worldButton, 1);
  fl_show_form(MainForm, FL_PLACE_SIZE, TRUE, "Tack Down");
  while(1) fl_do_forms();

}


void TransButtonProc(FL_OBJECT *o, long val) {
  char buf[256];
  Geom *g;
  Transform t;

  printf("(write geometry - targetgeom bare)");
  printf("(write transform - targetgeom %s)", 
	 fl_get_button(worldButton) ? "world" : "universe");
  fflush(stdout);
  
  g = GeomFLoad(stdin, NULL);
 
  TransStreamIn(standardIn, NULL, t);

  GeomTransform(g, t);

  printf("(freeze allcams)");
  printf("(geometry targetgeom {");
  GeomFSave(g, stdout, NULL);
  printf("})");
  printf("(xform-set targetgeom ");
  fputtransform(stdout, 1, &TM_IDENTITY[0][0], 0);
  printf(")");
  printf("(redraw allcams)");
  fflush(stdout);
  fl_set_button(TransButton, 0);

  GeomDelete(g); 
 
}


void QuitButtonProc(FL_OBJECT *o, long val) {
  exit(0);
}
