#include <stdio.h>
#include <color.h>

static ColorA  builtin[] = 	{
	{.8, .6, .2, .5},
	{.2, .8, .6, .5},
	{.6, .2, .8, .5}};
	
static ColorA *colormap = NULL;
static int cnt;

int
readcmap(cmapfname)
char *cmapfname;
{
	FILE *fp;
	int size = 256;
	
	if (cmapfname == NULL)	goto ZXCV;
	
	fp = fopen(cmapfname,"r");
	if (fp == NULL)		goto ZXCV;
	
	cnt = 0;
	colormap = (ColorA *) malloc(sizeof(ColorA) * size);
	
	while (fscanf(fp, "%f%f%f%f", 
		&colormap[cnt].r, &colormap[cnt].g, &colormap[cnt].b, &colormap[cnt].a) == 4)
		{
		cnt++;
		if (cnt > size)	{
			size *= 2;
			colormap = (ColorA *) realloc(colormap, sizeof(ColorA) * size);
			if (colormap == NULL) goto ZXCV;
			}
		}
	return(cnt);
/*
	fprintf(stderr,"readcmap: %d entries read\n",cnt);
*/
ZXCV:
	colormap = builtin;
	cnt = 3;
	return(cnt);
}

ColorA
GetCmapEntry(n)
int n;
{
	if (n < 0  || n > cnt)	return(colormap[0]);
	else return (colormap[n]);
}
