#ifndef API_h
#define API_H

/* Things implemented in common code to be called by machine-specific
 * code */
void apiInit();

int apiCheckPipes();
void apiDoPipes();

int apiVerifyUI();

void apiFreeze();
void apiThaw();

void apiTargetChanged();

void apiPreview();
void apiWarp();

void apiEdit();
void apiEditSet();
void apiEditSetAll();
void apiEditLocation();

void apiDelete();
void apiDeleteAll();
void apiPosition();

void apiUpdateGeom();
void apiUpdateScale();

void apiExit();

/* Things implemented in machine-specific code to be called by common
 * code */

void uiFreeze();
void uiThaw();

/* These two run panels as modal */
void uiError(const char *str1, const char *str2, const char *str3);
void uiEdit(const char *name);

void uiSetTarget(const char *target);
const char *uiGetTarget();

void uiSetCreateOnPick(int val);
int uiGetCreateOnPick();

void uiAddWidget(const char *name, int index);
void uiSetSelectedWidget(int index);
int uiGetSelectedWidget();
void uiSetWidgetName(const char *name, int index);
const char *uiGetWidgetName(int index);
int uiWidgetIndex(const char *name);
void uiDeleteWidget(int index);

void uiSetStrengthBounds(float min, float max);
void uiSetStrength(float strength);
float uiGetStrength();
void uiSetSmoothnessBounds(float min, float max);
void uiSetSmoothness(float smoothness);
float uiGetSmoothness();

void uiSetPoint(Point3 *pt);
void uiGetPoint(Point3 *pt);

void uiSetSteps(int steps);
int uiGetSteps();
void uiSetStart(int start);
int uiGetStart();
void uiSetEnd(int end);
int uiGetEnd();

void uiSetIntToGV(int val);
int uiGetIntToGV();
void uiSetIntToFiles(int val);
int uiGetIntToFiles();

void uiSetAutoUpdate(int val);
int uiGetAutoUpdate();

void uiSetRetain(int val);
int uiGetRetain();

void uiSetPrefix(const char *prefix);
const char *uiGetPrefix();

void uiSetPath(const char *path);
const char *uiGetPath();

void uiSetWidgetGeom(const char *geom);
const char *uiGetWidgetGeom();

void uiSetWidgetSize(float size);
float uiGetWidgetSize();

void uiSetRelativeSize(int val);
int uiGetRelativeSize();

void uiSetGridX(int x);
int uiGetGridX();
void uiSetGridY(int y);
int uiGetGridY();
void uiSetGridZ(int z);
int uiGetGridZ();


#endif


